package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.AggregatedPolicyComplianceCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.AuditEventCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.CloudPcConnectionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.CloudPcDeviceCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.CloudPcOverviewCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ConditionalAccessPolicyCoverageCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.CredentialUserRegistrationsSummaryCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.DeviceCompliancePolicySettingStateSummaryCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagedDeviceComplianceCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagedDeviceComplianceTrendCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementActionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementActionTenantDeploymentStatusCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementIntentCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepVersionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantCustomizedInformationCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantDetailedInformationCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantGroupCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantTagCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.WindowsDeviceMalwareStateCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.WindowsProtectionStateCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "aggregatedPolicyCompliances", 
    "auditEvents", 
    "cloudPcConnections", 
    "cloudPcDevices", 
    "cloudPcsOverview", 
    "conditionalAccessPolicyCoverages", 
    "credentialUserRegistrationsSummaries", 
    "deviceCompliancePolicySettingStateSummaries", 
    "managedDeviceCompliances", 
    "managedDeviceComplianceTrends", 
    "managementActions", 
    "managementActionTenantDeploymentStatuses", 
    "managementIntents", 
    "managementTemplateCollections", 
    "managementTemplates", 
    "managementTemplateSteps", 
    "managementTemplateStepVersions", 
    "tenantGroups", 
    "tenants", 
    "tenantsCustomizedInformation", 
    "tenantsDetailedInformation", 
    "tenantTags", 
    "windowsDeviceMalwareStates", 
    "windowsProtectionStates"})
@JsonInclude(Include.NON_NULL)
public class ManagedTenant extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managedTenant";
    }

    @JsonProperty("aggregatedPolicyCompliances")
    protected List<AggregatedPolicyCompliance> aggregatedPolicyCompliances;

    @JsonProperty("auditEvents")
    protected List<AuditEvent> auditEvents;

    @JsonProperty("cloudPcConnections")
    protected List<CloudPcConnection> cloudPcConnections;

    @JsonProperty("cloudPcDevices")
    protected List<CloudPcDevice> cloudPcDevices;

    @JsonProperty("cloudPcsOverview")
    protected List<CloudPcOverview> cloudPcsOverview;

    @JsonProperty("conditionalAccessPolicyCoverages")
    protected List<ConditionalAccessPolicyCoverage> conditionalAccessPolicyCoverages;

    @JsonProperty("credentialUserRegistrationsSummaries")
    protected List<CredentialUserRegistrationsSummary> credentialUserRegistrationsSummaries;

    @JsonProperty("deviceCompliancePolicySettingStateSummaries")
    protected List<DeviceCompliancePolicySettingStateSummary> deviceCompliancePolicySettingStateSummaries;

    @JsonProperty("managedDeviceCompliances")
    protected List<ManagedDeviceCompliance> managedDeviceCompliances;

    @JsonProperty("managedDeviceComplianceTrends")
    protected List<ManagedDeviceComplianceTrend> managedDeviceComplianceTrends;

    @JsonProperty("managementActions")
    protected List<ManagementAction> managementActions;

    @JsonProperty("managementActionTenantDeploymentStatuses")
    protected List<ManagementActionTenantDeploymentStatus> managementActionTenantDeploymentStatuses;

    @JsonProperty("managementIntents")
    protected List<ManagementIntent> managementIntents;

    @JsonProperty("managementTemplateCollections")
    protected List<ManagementTemplateCollection> managementTemplateCollections;

    @JsonProperty("managementTemplates")
    protected List<ManagementTemplate> managementTemplates;

    @JsonProperty("managementTemplateSteps")
    protected List<ManagementTemplateStep> managementTemplateSteps;

    @JsonProperty("managementTemplateStepVersions")
    protected List<ManagementTemplateStepVersion> managementTemplateStepVersions;

    @JsonProperty("tenantGroups")
    protected List<TenantGroup> tenantGroups;

    @JsonProperty("tenants")
    protected List<Tenant> tenants;

    @JsonProperty("tenantsCustomizedInformation")
    protected List<TenantCustomizedInformation> tenantsCustomizedInformation;

    @JsonProperty("tenantsDetailedInformation")
    protected List<TenantDetailedInformation> tenantsDetailedInformation;

    @JsonProperty("tenantTags")
    protected List<TenantTag> tenantTags;

    @JsonProperty("windowsDeviceMalwareStates")
    protected List<WindowsDeviceMalwareState> windowsDeviceMalwareStates;

    @JsonProperty("windowsProtectionStates")
    protected List<WindowsProtectionState> windowsProtectionStates;

    protected ManagedTenant() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedTenant() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<AggregatedPolicyCompliance> aggregatedPolicyCompliances;
        private List<AuditEvent> auditEvents;
        private List<CloudPcConnection> cloudPcConnections;
        private List<CloudPcDevice> cloudPcDevices;
        private List<CloudPcOverview> cloudPcsOverview;
        private List<ConditionalAccessPolicyCoverage> conditionalAccessPolicyCoverages;
        private List<CredentialUserRegistrationsSummary> credentialUserRegistrationsSummaries;
        private List<DeviceCompliancePolicySettingStateSummary> deviceCompliancePolicySettingStateSummaries;
        private List<ManagedDeviceCompliance> managedDeviceCompliances;
        private List<ManagedDeviceComplianceTrend> managedDeviceComplianceTrends;
        private List<ManagementAction> managementActions;
        private List<ManagementActionTenantDeploymentStatus> managementActionTenantDeploymentStatuses;
        private List<ManagementIntent> managementIntents;
        private List<ManagementTemplateCollection> managementTemplateCollections;
        private List<ManagementTemplate> managementTemplates;
        private List<ManagementTemplateStep> managementTemplateSteps;
        private List<ManagementTemplateStepVersion> managementTemplateStepVersions;
        private List<TenantGroup> tenantGroups;
        private List<Tenant> tenants;
        private List<TenantCustomizedInformation> tenantsCustomizedInformation;
        private List<TenantDetailedInformation> tenantsDetailedInformation;
        private List<TenantTag> tenantTags;
        private List<WindowsDeviceMalwareState> windowsDeviceMalwareStates;
        private List<WindowsProtectionState> windowsProtectionStates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder aggregatedPolicyCompliances(List<AggregatedPolicyCompliance> aggregatedPolicyCompliances) {
            this.aggregatedPolicyCompliances = aggregatedPolicyCompliances;
            this.changedFields = changedFields.add("aggregatedPolicyCompliances");
            return this;
        }

        public Builder aggregatedPolicyCompliances(AggregatedPolicyCompliance... aggregatedPolicyCompliances) {
            return aggregatedPolicyCompliances(Arrays.asList(aggregatedPolicyCompliances));
        }

        public Builder auditEvents(List<AuditEvent> auditEvents) {
            this.auditEvents = auditEvents;
            this.changedFields = changedFields.add("auditEvents");
            return this;
        }

        public Builder auditEvents(AuditEvent... auditEvents) {
            return auditEvents(Arrays.asList(auditEvents));
        }

        public Builder cloudPcConnections(List<CloudPcConnection> cloudPcConnections) {
            this.cloudPcConnections = cloudPcConnections;
            this.changedFields = changedFields.add("cloudPcConnections");
            return this;
        }

        public Builder cloudPcConnections(CloudPcConnection... cloudPcConnections) {
            return cloudPcConnections(Arrays.asList(cloudPcConnections));
        }

        public Builder cloudPcDevices(List<CloudPcDevice> cloudPcDevices) {
            this.cloudPcDevices = cloudPcDevices;
            this.changedFields = changedFields.add("cloudPcDevices");
            return this;
        }

        public Builder cloudPcDevices(CloudPcDevice... cloudPcDevices) {
            return cloudPcDevices(Arrays.asList(cloudPcDevices));
        }

        public Builder cloudPcsOverview(List<CloudPcOverview> cloudPcsOverview) {
            this.cloudPcsOverview = cloudPcsOverview;
            this.changedFields = changedFields.add("cloudPcsOverview");
            return this;
        }

        public Builder cloudPcsOverview(CloudPcOverview... cloudPcsOverview) {
            return cloudPcsOverview(Arrays.asList(cloudPcsOverview));
        }

        public Builder conditionalAccessPolicyCoverages(List<ConditionalAccessPolicyCoverage> conditionalAccessPolicyCoverages) {
            this.conditionalAccessPolicyCoverages = conditionalAccessPolicyCoverages;
            this.changedFields = changedFields.add("conditionalAccessPolicyCoverages");
            return this;
        }

        public Builder conditionalAccessPolicyCoverages(ConditionalAccessPolicyCoverage... conditionalAccessPolicyCoverages) {
            return conditionalAccessPolicyCoverages(Arrays.asList(conditionalAccessPolicyCoverages));
        }

        public Builder credentialUserRegistrationsSummaries(List<CredentialUserRegistrationsSummary> credentialUserRegistrationsSummaries) {
            this.credentialUserRegistrationsSummaries = credentialUserRegistrationsSummaries;
            this.changedFields = changedFields.add("credentialUserRegistrationsSummaries");
            return this;
        }

        public Builder credentialUserRegistrationsSummaries(CredentialUserRegistrationsSummary... credentialUserRegistrationsSummaries) {
            return credentialUserRegistrationsSummaries(Arrays.asList(credentialUserRegistrationsSummaries));
        }

        public Builder deviceCompliancePolicySettingStateSummaries(List<DeviceCompliancePolicySettingStateSummary> deviceCompliancePolicySettingStateSummaries) {
            this.deviceCompliancePolicySettingStateSummaries = deviceCompliancePolicySettingStateSummaries;
            this.changedFields = changedFields.add("deviceCompliancePolicySettingStateSummaries");
            return this;
        }

        public Builder deviceCompliancePolicySettingStateSummaries(DeviceCompliancePolicySettingStateSummary... deviceCompliancePolicySettingStateSummaries) {
            return deviceCompliancePolicySettingStateSummaries(Arrays.asList(deviceCompliancePolicySettingStateSummaries));
        }

        public Builder managedDeviceCompliances(List<ManagedDeviceCompliance> managedDeviceCompliances) {
            this.managedDeviceCompliances = managedDeviceCompliances;
            this.changedFields = changedFields.add("managedDeviceCompliances");
            return this;
        }

        public Builder managedDeviceCompliances(ManagedDeviceCompliance... managedDeviceCompliances) {
            return managedDeviceCompliances(Arrays.asList(managedDeviceCompliances));
        }

        public Builder managedDeviceComplianceTrends(List<ManagedDeviceComplianceTrend> managedDeviceComplianceTrends) {
            this.managedDeviceComplianceTrends = managedDeviceComplianceTrends;
            this.changedFields = changedFields.add("managedDeviceComplianceTrends");
            return this;
        }

        public Builder managedDeviceComplianceTrends(ManagedDeviceComplianceTrend... managedDeviceComplianceTrends) {
            return managedDeviceComplianceTrends(Arrays.asList(managedDeviceComplianceTrends));
        }

        public Builder managementActions(List<ManagementAction> managementActions) {
            this.managementActions = managementActions;
            this.changedFields = changedFields.add("managementActions");
            return this;
        }

        public Builder managementActions(ManagementAction... managementActions) {
            return managementActions(Arrays.asList(managementActions));
        }

        public Builder managementActionTenantDeploymentStatuses(List<ManagementActionTenantDeploymentStatus> managementActionTenantDeploymentStatuses) {
            this.managementActionTenantDeploymentStatuses = managementActionTenantDeploymentStatuses;
            this.changedFields = changedFields.add("managementActionTenantDeploymentStatuses");
            return this;
        }

        public Builder managementActionTenantDeploymentStatuses(ManagementActionTenantDeploymentStatus... managementActionTenantDeploymentStatuses) {
            return managementActionTenantDeploymentStatuses(Arrays.asList(managementActionTenantDeploymentStatuses));
        }

        public Builder managementIntents(List<ManagementIntent> managementIntents) {
            this.managementIntents = managementIntents;
            this.changedFields = changedFields.add("managementIntents");
            return this;
        }

        public Builder managementIntents(ManagementIntent... managementIntents) {
            return managementIntents(Arrays.asList(managementIntents));
        }

        public Builder managementTemplateCollections(List<ManagementTemplateCollection> managementTemplateCollections) {
            this.managementTemplateCollections = managementTemplateCollections;
            this.changedFields = changedFields.add("managementTemplateCollections");
            return this;
        }

        public Builder managementTemplateCollections(ManagementTemplateCollection... managementTemplateCollections) {
            return managementTemplateCollections(Arrays.asList(managementTemplateCollections));
        }

        public Builder managementTemplates(List<ManagementTemplate> managementTemplates) {
            this.managementTemplates = managementTemplates;
            this.changedFields = changedFields.add("managementTemplates");
            return this;
        }

        public Builder managementTemplates(ManagementTemplate... managementTemplates) {
            return managementTemplates(Arrays.asList(managementTemplates));
        }

        public Builder managementTemplateSteps(List<ManagementTemplateStep> managementTemplateSteps) {
            this.managementTemplateSteps = managementTemplateSteps;
            this.changedFields = changedFields.add("managementTemplateSteps");
            return this;
        }

        public Builder managementTemplateSteps(ManagementTemplateStep... managementTemplateSteps) {
            return managementTemplateSteps(Arrays.asList(managementTemplateSteps));
        }

        public Builder managementTemplateStepVersions(List<ManagementTemplateStepVersion> managementTemplateStepVersions) {
            this.managementTemplateStepVersions = managementTemplateStepVersions;
            this.changedFields = changedFields.add("managementTemplateStepVersions");
            return this;
        }

        public Builder managementTemplateStepVersions(ManagementTemplateStepVersion... managementTemplateStepVersions) {
            return managementTemplateStepVersions(Arrays.asList(managementTemplateStepVersions));
        }

        public Builder tenantGroups(List<TenantGroup> tenantGroups) {
            this.tenantGroups = tenantGroups;
            this.changedFields = changedFields.add("tenantGroups");
            return this;
        }

        public Builder tenantGroups(TenantGroup... tenantGroups) {
            return tenantGroups(Arrays.asList(tenantGroups));
        }

        public Builder tenants(List<Tenant> tenants) {
            this.tenants = tenants;
            this.changedFields = changedFields.add("tenants");
            return this;
        }

        public Builder tenants(Tenant... tenants) {
            return tenants(Arrays.asList(tenants));
        }

        public Builder tenantsCustomizedInformation(List<TenantCustomizedInformation> tenantsCustomizedInformation) {
            this.tenantsCustomizedInformation = tenantsCustomizedInformation;
            this.changedFields = changedFields.add("tenantsCustomizedInformation");
            return this;
        }

        public Builder tenantsCustomizedInformation(TenantCustomizedInformation... tenantsCustomizedInformation) {
            return tenantsCustomizedInformation(Arrays.asList(tenantsCustomizedInformation));
        }

        public Builder tenantsDetailedInformation(List<TenantDetailedInformation> tenantsDetailedInformation) {
            this.tenantsDetailedInformation = tenantsDetailedInformation;
            this.changedFields = changedFields.add("tenantsDetailedInformation");
            return this;
        }

        public Builder tenantsDetailedInformation(TenantDetailedInformation... tenantsDetailedInformation) {
            return tenantsDetailedInformation(Arrays.asList(tenantsDetailedInformation));
        }

        public Builder tenantTags(List<TenantTag> tenantTags) {
            this.tenantTags = tenantTags;
            this.changedFields = changedFields.add("tenantTags");
            return this;
        }

        public Builder tenantTags(TenantTag... tenantTags) {
            return tenantTags(Arrays.asList(tenantTags));
        }

        public Builder windowsDeviceMalwareStates(List<WindowsDeviceMalwareState> windowsDeviceMalwareStates) {
            this.windowsDeviceMalwareStates = windowsDeviceMalwareStates;
            this.changedFields = changedFields.add("windowsDeviceMalwareStates");
            return this;
        }

        public Builder windowsDeviceMalwareStates(WindowsDeviceMalwareState... windowsDeviceMalwareStates) {
            return windowsDeviceMalwareStates(Arrays.asList(windowsDeviceMalwareStates));
        }

        public Builder windowsProtectionStates(List<WindowsProtectionState> windowsProtectionStates) {
            this.windowsProtectionStates = windowsProtectionStates;
            this.changedFields = changedFields.add("windowsProtectionStates");
            return this;
        }

        public Builder windowsProtectionStates(WindowsProtectionState... windowsProtectionStates) {
            return windowsProtectionStates(Arrays.asList(windowsProtectionStates));
        }

        public ManagedTenant build() {
            ManagedTenant _x = new ManagedTenant();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managedTenant";
            _x.id = id;
            _x.aggregatedPolicyCompliances = aggregatedPolicyCompliances;
            _x.auditEvents = auditEvents;
            _x.cloudPcConnections = cloudPcConnections;
            _x.cloudPcDevices = cloudPcDevices;
            _x.cloudPcsOverview = cloudPcsOverview;
            _x.conditionalAccessPolicyCoverages = conditionalAccessPolicyCoverages;
            _x.credentialUserRegistrationsSummaries = credentialUserRegistrationsSummaries;
            _x.deviceCompliancePolicySettingStateSummaries = deviceCompliancePolicySettingStateSummaries;
            _x.managedDeviceCompliances = managedDeviceCompliances;
            _x.managedDeviceComplianceTrends = managedDeviceComplianceTrends;
            _x.managementActions = managementActions;
            _x.managementActionTenantDeploymentStatuses = managementActionTenantDeploymentStatuses;
            _x.managementIntents = managementIntents;
            _x.managementTemplateCollections = managementTemplateCollections;
            _x.managementTemplates = managementTemplates;
            _x.managementTemplateSteps = managementTemplateSteps;
            _x.managementTemplateStepVersions = managementTemplateStepVersions;
            _x.tenantGroups = tenantGroups;
            _x.tenants = tenants;
            _x.tenantsCustomizedInformation = tenantsCustomizedInformation;
            _x.tenantsDetailedInformation = tenantsDetailedInformation;
            _x.tenantTags = tenantTags;
            _x.windowsDeviceMalwareStates = windowsDeviceMalwareStates;
            _x.windowsProtectionStates = windowsProtectionStates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public ManagedTenant withUnmappedField(String name, Object value) {
        ManagedTenant _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="aggregatedPolicyCompliances")
    @JsonIgnore
    public AggregatedPolicyComplianceCollectionRequest getAggregatedPolicyCompliances() {
        return new AggregatedPolicyComplianceCollectionRequest(
                        contextPath.addSegment("aggregatedPolicyCompliances"), Optional.ofNullable(aggregatedPolicyCompliances));
    }

    @NavigationProperty(name="auditEvents")
    @JsonIgnore
    public AuditEventCollectionRequest getAuditEvents() {
        return new AuditEventCollectionRequest(
                        contextPath.addSegment("auditEvents"), Optional.ofNullable(auditEvents));
    }

    @NavigationProperty(name="cloudPcConnections")
    @JsonIgnore
    public CloudPcConnectionCollectionRequest getCloudPcConnections() {
        return new CloudPcConnectionCollectionRequest(
                        contextPath.addSegment("cloudPcConnections"), Optional.ofNullable(cloudPcConnections));
    }

    @NavigationProperty(name="cloudPcDevices")
    @JsonIgnore
    public CloudPcDeviceCollectionRequest getCloudPcDevices() {
        return new CloudPcDeviceCollectionRequest(
                        contextPath.addSegment("cloudPcDevices"), Optional.ofNullable(cloudPcDevices));
    }

    @NavigationProperty(name="cloudPcsOverview")
    @JsonIgnore
    public CloudPcOverviewCollectionRequest getCloudPcsOverview() {
        return new CloudPcOverviewCollectionRequest(
                        contextPath.addSegment("cloudPcsOverview"), Optional.ofNullable(cloudPcsOverview));
    }

    @NavigationProperty(name="conditionalAccessPolicyCoverages")
    @JsonIgnore
    public ConditionalAccessPolicyCoverageCollectionRequest getConditionalAccessPolicyCoverages() {
        return new ConditionalAccessPolicyCoverageCollectionRequest(
                        contextPath.addSegment("conditionalAccessPolicyCoverages"), Optional.ofNullable(conditionalAccessPolicyCoverages));
    }

    @NavigationProperty(name="credentialUserRegistrationsSummaries")
    @JsonIgnore
    public CredentialUserRegistrationsSummaryCollectionRequest getCredentialUserRegistrationsSummaries() {
        return new CredentialUserRegistrationsSummaryCollectionRequest(
                        contextPath.addSegment("credentialUserRegistrationsSummaries"), Optional.ofNullable(credentialUserRegistrationsSummaries));
    }

    @NavigationProperty(name="deviceCompliancePolicySettingStateSummaries")
    @JsonIgnore
    public DeviceCompliancePolicySettingStateSummaryCollectionRequest getDeviceCompliancePolicySettingStateSummaries() {
        return new DeviceCompliancePolicySettingStateSummaryCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicySettingStateSummaries"), Optional.ofNullable(deviceCompliancePolicySettingStateSummaries));
    }

    @NavigationProperty(name="managedDeviceCompliances")
    @JsonIgnore
    public ManagedDeviceComplianceCollectionRequest getManagedDeviceCompliances() {
        return new ManagedDeviceComplianceCollectionRequest(
                        contextPath.addSegment("managedDeviceCompliances"), Optional.ofNullable(managedDeviceCompliances));
    }

    @NavigationProperty(name="managedDeviceComplianceTrends")
    @JsonIgnore
    public ManagedDeviceComplianceTrendCollectionRequest getManagedDeviceComplianceTrends() {
        return new ManagedDeviceComplianceTrendCollectionRequest(
                        contextPath.addSegment("managedDeviceComplianceTrends"), Optional.ofNullable(managedDeviceComplianceTrends));
    }

    @NavigationProperty(name="managementActions")
    @JsonIgnore
    public ManagementActionCollectionRequest getManagementActions() {
        return new ManagementActionCollectionRequest(
                        contextPath.addSegment("managementActions"), Optional.ofNullable(managementActions));
    }

    @NavigationProperty(name="managementActionTenantDeploymentStatuses")
    @JsonIgnore
    public ManagementActionTenantDeploymentStatusCollectionRequest getManagementActionTenantDeploymentStatuses() {
        return new ManagementActionTenantDeploymentStatusCollectionRequest(
                        contextPath.addSegment("managementActionTenantDeploymentStatuses"), Optional.ofNullable(managementActionTenantDeploymentStatuses));
    }

    @NavigationProperty(name="managementIntents")
    @JsonIgnore
    public ManagementIntentCollectionRequest getManagementIntents() {
        return new ManagementIntentCollectionRequest(
                        contextPath.addSegment("managementIntents"), Optional.ofNullable(managementIntents));
    }

    @NavigationProperty(name="managementTemplateCollections")
    @JsonIgnore
    public ManagementTemplateCollectionCollectionRequest getManagementTemplateCollections() {
        return new ManagementTemplateCollectionCollectionRequest(
                        contextPath.addSegment("managementTemplateCollections"), Optional.ofNullable(managementTemplateCollections));
    }

    @NavigationProperty(name="managementTemplates")
    @JsonIgnore
    public ManagementTemplateCollectionRequest getManagementTemplates() {
        return new ManagementTemplateCollectionRequest(
                        contextPath.addSegment("managementTemplates"), Optional.ofNullable(managementTemplates));
    }

    @NavigationProperty(name="managementTemplateSteps")
    @JsonIgnore
    public ManagementTemplateStepCollectionRequest getManagementTemplateSteps() {
        return new ManagementTemplateStepCollectionRequest(
                        contextPath.addSegment("managementTemplateSteps"), Optional.ofNullable(managementTemplateSteps));
    }

    @NavigationProperty(name="managementTemplateStepVersions")
    @JsonIgnore
    public ManagementTemplateStepVersionCollectionRequest getManagementTemplateStepVersions() {
        return new ManagementTemplateStepVersionCollectionRequest(
                        contextPath.addSegment("managementTemplateStepVersions"), Optional.ofNullable(managementTemplateStepVersions));
    }

    @NavigationProperty(name="tenantGroups")
    @JsonIgnore
    public TenantGroupCollectionRequest getTenantGroups() {
        return new TenantGroupCollectionRequest(
                        contextPath.addSegment("tenantGroups"), Optional.ofNullable(tenantGroups));
    }

    @NavigationProperty(name="tenants")
    @JsonIgnore
    public TenantCollectionRequest getTenants() {
        return new TenantCollectionRequest(
                        contextPath.addSegment("tenants"), Optional.ofNullable(tenants));
    }

    @NavigationProperty(name="tenantsCustomizedInformation")
    @JsonIgnore
    public TenantCustomizedInformationCollectionRequest getTenantsCustomizedInformation() {
        return new TenantCustomizedInformationCollectionRequest(
                        contextPath.addSegment("tenantsCustomizedInformation"), Optional.ofNullable(tenantsCustomizedInformation));
    }

    @NavigationProperty(name="tenantsDetailedInformation")
    @JsonIgnore
    public TenantDetailedInformationCollectionRequest getTenantsDetailedInformation() {
        return new TenantDetailedInformationCollectionRequest(
                        contextPath.addSegment("tenantsDetailedInformation"), Optional.ofNullable(tenantsDetailedInformation));
    }

    @NavigationProperty(name="tenantTags")
    @JsonIgnore
    public TenantTagCollectionRequest getTenantTags() {
        return new TenantTagCollectionRequest(
                        contextPath.addSegment("tenantTags"), Optional.ofNullable(tenantTags));
    }

    @NavigationProperty(name="windowsDeviceMalwareStates")
    @JsonIgnore
    public WindowsDeviceMalwareStateCollectionRequest getWindowsDeviceMalwareStates() {
        return new WindowsDeviceMalwareStateCollectionRequest(
                        contextPath.addSegment("windowsDeviceMalwareStates"), Optional.ofNullable(windowsDeviceMalwareStates));
    }

    @NavigationProperty(name="windowsProtectionStates")
    @JsonIgnore
    public WindowsProtectionStateCollectionRequest getWindowsProtectionStates() {
        return new WindowsProtectionStateCollectionRequest(
                        contextPath.addSegment("windowsProtectionStates"), Optional.ofNullable(windowsProtectionStates));
    }

    public ManagedTenant withAggregatedPolicyCompliances(List<AggregatedPolicyCompliance> aggregatedPolicyCompliances) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("aggregatedPolicyCompliances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.aggregatedPolicyCompliances = aggregatedPolicyCompliances;
        return _x;
    }

    public ManagedTenant withAuditEvents(List<AuditEvent> auditEvents) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("auditEvents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.auditEvents = auditEvents;
        return _x;
    }

    public ManagedTenant withCloudPcConnections(List<CloudPcConnection> cloudPcConnections) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("cloudPcConnections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.cloudPcConnections = cloudPcConnections;
        return _x;
    }

    public ManagedTenant withCloudPcDevices(List<CloudPcDevice> cloudPcDevices) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("cloudPcDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.cloudPcDevices = cloudPcDevices;
        return _x;
    }

    public ManagedTenant withCloudPcsOverview(List<CloudPcOverview> cloudPcsOverview) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("cloudPcsOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.cloudPcsOverview = cloudPcsOverview;
        return _x;
    }

    public ManagedTenant withConditionalAccessPolicyCoverages(List<ConditionalAccessPolicyCoverage> conditionalAccessPolicyCoverages) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("conditionalAccessPolicyCoverages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.conditionalAccessPolicyCoverages = conditionalAccessPolicyCoverages;
        return _x;
    }

    public ManagedTenant withCredentialUserRegistrationsSummaries(List<CredentialUserRegistrationsSummary> credentialUserRegistrationsSummaries) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("credentialUserRegistrationsSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.credentialUserRegistrationsSummaries = credentialUserRegistrationsSummaries;
        return _x;
    }

    public ManagedTenant withDeviceCompliancePolicySettingStateSummaries(List<DeviceCompliancePolicySettingStateSummary> deviceCompliancePolicySettingStateSummaries) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("deviceCompliancePolicySettingStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.deviceCompliancePolicySettingStateSummaries = deviceCompliancePolicySettingStateSummaries;
        return _x;
    }

    public ManagedTenant withManagedDeviceCompliances(List<ManagedDeviceCompliance> managedDeviceCompliances) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceCompliances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managedDeviceCompliances = managedDeviceCompliances;
        return _x;
    }

    public ManagedTenant withManagedDeviceComplianceTrends(List<ManagedDeviceComplianceTrend> managedDeviceComplianceTrends) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceComplianceTrends");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managedDeviceComplianceTrends = managedDeviceComplianceTrends;
        return _x;
    }

    public ManagedTenant withManagementActions(List<ManagementAction> managementActions) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managementActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managementActions = managementActions;
        return _x;
    }

    public ManagedTenant withManagementActionTenantDeploymentStatuses(List<ManagementActionTenantDeploymentStatus> managementActionTenantDeploymentStatuses) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managementActionTenantDeploymentStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managementActionTenantDeploymentStatuses = managementActionTenantDeploymentStatuses;
        return _x;
    }

    public ManagedTenant withManagementIntents(List<ManagementIntent> managementIntents) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managementIntents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managementIntents = managementIntents;
        return _x;
    }

    public ManagedTenant withManagementTemplateCollections(List<ManagementTemplateCollection> managementTemplateCollections) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managementTemplateCollections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managementTemplateCollections = managementTemplateCollections;
        return _x;
    }

    public ManagedTenant withManagementTemplates(List<ManagementTemplate> managementTemplates) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managementTemplates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managementTemplates = managementTemplates;
        return _x;
    }

    public ManagedTenant withManagementTemplateSteps(List<ManagementTemplateStep> managementTemplateSteps) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managementTemplateSteps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managementTemplateSteps = managementTemplateSteps;
        return _x;
    }

    public ManagedTenant withManagementTemplateStepVersions(List<ManagementTemplateStepVersion> managementTemplateStepVersions) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("managementTemplateStepVersions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.managementTemplateStepVersions = managementTemplateStepVersions;
        return _x;
    }

    public ManagedTenant withTenantGroups(List<TenantGroup> tenantGroups) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("tenantGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.tenantGroups = tenantGroups;
        return _x;
    }

    public ManagedTenant withTenants(List<Tenant> tenants) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("tenants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.tenants = tenants;
        return _x;
    }

    public ManagedTenant withTenantsCustomizedInformation(List<TenantCustomizedInformation> tenantsCustomizedInformation) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("tenantsCustomizedInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.tenantsCustomizedInformation = tenantsCustomizedInformation;
        return _x;
    }

    public ManagedTenant withTenantsDetailedInformation(List<TenantDetailedInformation> tenantsDetailedInformation) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("tenantsDetailedInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.tenantsDetailedInformation = tenantsDetailedInformation;
        return _x;
    }

    public ManagedTenant withTenantTags(List<TenantTag> tenantTags) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("tenantTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.tenantTags = tenantTags;
        return _x;
    }

    public ManagedTenant withWindowsDeviceMalwareStates(List<WindowsDeviceMalwareState> windowsDeviceMalwareStates) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("windowsDeviceMalwareStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.windowsDeviceMalwareStates = windowsDeviceMalwareStates;
        return _x;
    }

    public ManagedTenant withWindowsProtectionStates(List<WindowsProtectionState> windowsProtectionStates) {
        ManagedTenant _x = _copy();
        _x.changedFields = changedFields.add("windowsProtectionStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenant");
        _x.windowsProtectionStates = windowsProtectionStates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedTenant patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedTenant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedTenant put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedTenant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedTenant _copy() {
        ManagedTenant _x = new ManagedTenant();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.aggregatedPolicyCompliances = aggregatedPolicyCompliances;
        _x.auditEvents = auditEvents;
        _x.cloudPcConnections = cloudPcConnections;
        _x.cloudPcDevices = cloudPcDevices;
        _x.cloudPcsOverview = cloudPcsOverview;
        _x.conditionalAccessPolicyCoverages = conditionalAccessPolicyCoverages;
        _x.credentialUserRegistrationsSummaries = credentialUserRegistrationsSummaries;
        _x.deviceCompliancePolicySettingStateSummaries = deviceCompliancePolicySettingStateSummaries;
        _x.managedDeviceCompliances = managedDeviceCompliances;
        _x.managedDeviceComplianceTrends = managedDeviceComplianceTrends;
        _x.managementActions = managementActions;
        _x.managementActionTenantDeploymentStatuses = managementActionTenantDeploymentStatuses;
        _x.managementIntents = managementIntents;
        _x.managementTemplateCollections = managementTemplateCollections;
        _x.managementTemplates = managementTemplates;
        _x.managementTemplateSteps = managementTemplateSteps;
        _x.managementTemplateStepVersions = managementTemplateStepVersions;
        _x.tenantGroups = tenantGroups;
        _x.tenants = tenants;
        _x.tenantsCustomizedInformation = tenantsCustomizedInformation;
        _x.tenantsDetailedInformation = tenantsDetailedInformation;
        _x.tenantTags = tenantTags;
        _x.windowsDeviceMalwareStates = windowsDeviceMalwareStates;
        _x.windowsProtectionStates = windowsProtectionStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedTenant[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("aggregatedPolicyCompliances=");
        b.append(this.aggregatedPolicyCompliances);
        b.append(", ");
        b.append("auditEvents=");
        b.append(this.auditEvents);
        b.append(", ");
        b.append("cloudPcConnections=");
        b.append(this.cloudPcConnections);
        b.append(", ");
        b.append("cloudPcDevices=");
        b.append(this.cloudPcDevices);
        b.append(", ");
        b.append("cloudPcsOverview=");
        b.append(this.cloudPcsOverview);
        b.append(", ");
        b.append("conditionalAccessPolicyCoverages=");
        b.append(this.conditionalAccessPolicyCoverages);
        b.append(", ");
        b.append("credentialUserRegistrationsSummaries=");
        b.append(this.credentialUserRegistrationsSummaries);
        b.append(", ");
        b.append("deviceCompliancePolicySettingStateSummaries=");
        b.append(this.deviceCompliancePolicySettingStateSummaries);
        b.append(", ");
        b.append("managedDeviceCompliances=");
        b.append(this.managedDeviceCompliances);
        b.append(", ");
        b.append("managedDeviceComplianceTrends=");
        b.append(this.managedDeviceComplianceTrends);
        b.append(", ");
        b.append("managementActions=");
        b.append(this.managementActions);
        b.append(", ");
        b.append("managementActionTenantDeploymentStatuses=");
        b.append(this.managementActionTenantDeploymentStatuses);
        b.append(", ");
        b.append("managementIntents=");
        b.append(this.managementIntents);
        b.append(", ");
        b.append("managementTemplateCollections=");
        b.append(this.managementTemplateCollections);
        b.append(", ");
        b.append("managementTemplates=");
        b.append(this.managementTemplates);
        b.append(", ");
        b.append("managementTemplateSteps=");
        b.append(this.managementTemplateSteps);
        b.append(", ");
        b.append("managementTemplateStepVersions=");
        b.append(this.managementTemplateStepVersions);
        b.append(", ");
        b.append("tenantGroups=");
        b.append(this.tenantGroups);
        b.append(", ");
        b.append("tenants=");
        b.append(this.tenants);
        b.append(", ");
        b.append("tenantsCustomizedInformation=");
        b.append(this.tenantsCustomizedInformation);
        b.append(", ");
        b.append("tenantsDetailedInformation=");
        b.append(this.tenantsDetailedInformation);
        b.append(", ");
        b.append("tenantTags=");
        b.append(this.tenantTags);
        b.append(", ");
        b.append("windowsDeviceMalwareStates=");
        b.append(this.windowsDeviceMalwareStates);
        b.append(", ");
        b.append("windowsProtectionStates=");
        b.append(this.windowsProtectionStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
