package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "compliantDeviceCount", 
    "configManagerDeviceCount", 
    "countDateTime", 
    "errorDeviceCount", 
    "inGracePeriodDeviceCount", 
    "noncompliantDeviceCount", 
    "tenantDisplayName", 
    "tenantId", 
    "unknownDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceComplianceTrend extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managedDeviceComplianceTrend";
    }

    @JsonProperty("compliantDeviceCount")
    protected Integer compliantDeviceCount;

    @JsonProperty("configManagerDeviceCount")
    protected Integer configManagerDeviceCount;

    @JsonProperty("countDateTime")
    protected String countDateTime;

    @JsonProperty("errorDeviceCount")
    protected Integer errorDeviceCount;

    @JsonProperty("inGracePeriodDeviceCount")
    protected Integer inGracePeriodDeviceCount;

    @JsonProperty("noncompliantDeviceCount")
    protected Integer noncompliantDeviceCount;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("unknownDeviceCount")
    protected Integer unknownDeviceCount;

    protected ManagedDeviceComplianceTrend() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedDeviceComplianceTrend() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer compliantDeviceCount;
        private Integer configManagerDeviceCount;
        private String countDateTime;
        private Integer errorDeviceCount;
        private Integer inGracePeriodDeviceCount;
        private Integer noncompliantDeviceCount;
        private String tenantDisplayName;
        private String tenantId;
        private Integer unknownDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder compliantDeviceCount(Integer compliantDeviceCount) {
            this.compliantDeviceCount = compliantDeviceCount;
            this.changedFields = changedFields.add("compliantDeviceCount");
            return this;
        }

        public Builder configManagerDeviceCount(Integer configManagerDeviceCount) {
            this.configManagerDeviceCount = configManagerDeviceCount;
            this.changedFields = changedFields.add("configManagerDeviceCount");
            return this;
        }

        public Builder countDateTime(String countDateTime) {
            this.countDateTime = countDateTime;
            this.changedFields = changedFields.add("countDateTime");
            return this;
        }

        public Builder errorDeviceCount(Integer errorDeviceCount) {
            this.errorDeviceCount = errorDeviceCount;
            this.changedFields = changedFields.add("errorDeviceCount");
            return this;
        }

        public Builder inGracePeriodDeviceCount(Integer inGracePeriodDeviceCount) {
            this.inGracePeriodDeviceCount = inGracePeriodDeviceCount;
            this.changedFields = changedFields.add("inGracePeriodDeviceCount");
            return this;
        }

        public Builder noncompliantDeviceCount(Integer noncompliantDeviceCount) {
            this.noncompliantDeviceCount = noncompliantDeviceCount;
            this.changedFields = changedFields.add("noncompliantDeviceCount");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder unknownDeviceCount(Integer unknownDeviceCount) {
            this.unknownDeviceCount = unknownDeviceCount;
            this.changedFields = changedFields.add("unknownDeviceCount");
            return this;
        }

        public ManagedDeviceComplianceTrend build() {
            ManagedDeviceComplianceTrend _x = new ManagedDeviceComplianceTrend();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managedDeviceComplianceTrend";
            _x.id = id;
            _x.compliantDeviceCount = compliantDeviceCount;
            _x.configManagerDeviceCount = configManagerDeviceCount;
            _x.countDateTime = countDateTime;
            _x.errorDeviceCount = errorDeviceCount;
            _x.inGracePeriodDeviceCount = inGracePeriodDeviceCount;
            _x.noncompliantDeviceCount = noncompliantDeviceCount;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            _x.unknownDeviceCount = unknownDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="compliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getCompliantDeviceCount() {
        return Optional.ofNullable(compliantDeviceCount);
    }

    public ManagedDeviceComplianceTrend withCompliantDeviceCount(Integer compliantDeviceCount) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("compliantDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.compliantDeviceCount = compliantDeviceCount;
        return _x;
    }

    @Property(name="configManagerDeviceCount")
    @JsonIgnore
    public Optional<Integer> getConfigManagerDeviceCount() {
        return Optional.ofNullable(configManagerDeviceCount);
    }

    public ManagedDeviceComplianceTrend withConfigManagerDeviceCount(Integer configManagerDeviceCount) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("configManagerDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.configManagerDeviceCount = configManagerDeviceCount;
        return _x;
    }

    @Property(name="countDateTime")
    @JsonIgnore
    public Optional<String> getCountDateTime() {
        return Optional.ofNullable(countDateTime);
    }

    public ManagedDeviceComplianceTrend withCountDateTime(String countDateTime) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("countDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.countDateTime = countDateTime;
        return _x;
    }

    @Property(name="errorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getErrorDeviceCount() {
        return Optional.ofNullable(errorDeviceCount);
    }

    public ManagedDeviceComplianceTrend withErrorDeviceCount(Integer errorDeviceCount) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("errorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.errorDeviceCount = errorDeviceCount;
        return _x;
    }

    @Property(name="inGracePeriodDeviceCount")
    @JsonIgnore
    public Optional<Integer> getInGracePeriodDeviceCount() {
        return Optional.ofNullable(inGracePeriodDeviceCount);
    }

    public ManagedDeviceComplianceTrend withInGracePeriodDeviceCount(Integer inGracePeriodDeviceCount) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("inGracePeriodDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.inGracePeriodDeviceCount = inGracePeriodDeviceCount;
        return _x;
    }

    @Property(name="noncompliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNoncompliantDeviceCount() {
        return Optional.ofNullable(noncompliantDeviceCount);
    }

    public ManagedDeviceComplianceTrend withNoncompliantDeviceCount(Integer noncompliantDeviceCount) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("noncompliantDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.noncompliantDeviceCount = noncompliantDeviceCount;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public ManagedDeviceComplianceTrend withTenantDisplayName(String tenantDisplayName) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public ManagedDeviceComplianceTrend withTenantId(String tenantId) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="unknownDeviceCount")
    @JsonIgnore
    public Optional<Integer> getUnknownDeviceCount() {
        return Optional.ofNullable(unknownDeviceCount);
    }

    public ManagedDeviceComplianceTrend withUnknownDeviceCount(Integer unknownDeviceCount) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = changedFields.add("unknownDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceComplianceTrend");
        _x.unknownDeviceCount = unknownDeviceCount;
        return _x;
    }

    public ManagedDeviceComplianceTrend withUnmappedField(String name, Object value) {
        ManagedDeviceComplianceTrend _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceComplianceTrend patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceComplianceTrend put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceComplianceTrend _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDeviceComplianceTrend _copy() {
        ManagedDeviceComplianceTrend _x = new ManagedDeviceComplianceTrend();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.compliantDeviceCount = compliantDeviceCount;
        _x.configManagerDeviceCount = configManagerDeviceCount;
        _x.countDateTime = countDateTime;
        _x.errorDeviceCount = errorDeviceCount;
        _x.inGracePeriodDeviceCount = inGracePeriodDeviceCount;
        _x.noncompliantDeviceCount = noncompliantDeviceCount;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        _x.unknownDeviceCount = unknownDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceComplianceTrend[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("compliantDeviceCount=");
        b.append(this.compliantDeviceCount);
        b.append(", ");
        b.append("configManagerDeviceCount=");
        b.append(this.configManagerDeviceCount);
        b.append(", ");
        b.append("countDateTime=");
        b.append(this.countDateTime);
        b.append(", ");
        b.append("errorDeviceCount=");
        b.append(this.errorDeviceCount);
        b.append(", ");
        b.append("inGracePeriodDeviceCount=");
        b.append(this.inGracePeriodDeviceCount);
        b.append(", ");
        b.append("noncompliantDeviceCount=");
        b.append(this.noncompliantDeviceCount);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("unknownDeviceCount=");
        b.append(this.unknownDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
