package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "conflictDeviceCount", 
    "errorDeviceCount", 
    "failedDeviceCount", 
    "intuneAccountId", 
    "intuneSettingId", 
    "lastRefreshedDateTime", 
    "notApplicableDeviceCount", 
    "pendingDeviceCount", 
    "policyType", 
    "settingName", 
    "succeededDeviceCount", 
    "tenantDisplayName", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class DeviceCompliancePolicySettingStateSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary";
    }

    @JsonProperty("conflictDeviceCount")
    protected Integer conflictDeviceCount;

    @JsonProperty("errorDeviceCount")
    protected Integer errorDeviceCount;

    @JsonProperty("failedDeviceCount")
    protected Integer failedDeviceCount;

    @JsonProperty("intuneAccountId")
    protected String intuneAccountId;

    @JsonProperty("intuneSettingId")
    protected String intuneSettingId;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("notApplicableDeviceCount")
    protected Integer notApplicableDeviceCount;

    @JsonProperty("pendingDeviceCount")
    protected Integer pendingDeviceCount;

    @JsonProperty("policyType")
    protected String policyType;

    @JsonProperty("settingName")
    protected String settingName;

    @JsonProperty("succeededDeviceCount")
    protected Integer succeededDeviceCount;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected DeviceCompliancePolicySettingStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceCompliancePolicySettingStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer conflictDeviceCount;
        private Integer errorDeviceCount;
        private Integer failedDeviceCount;
        private String intuneAccountId;
        private String intuneSettingId;
        private OffsetDateTime lastRefreshedDateTime;
        private Integer notApplicableDeviceCount;
        private Integer pendingDeviceCount;
        private String policyType;
        private String settingName;
        private Integer succeededDeviceCount;
        private String tenantDisplayName;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder conflictDeviceCount(Integer conflictDeviceCount) {
            this.conflictDeviceCount = conflictDeviceCount;
            this.changedFields = changedFields.add("conflictDeviceCount");
            return this;
        }

        public Builder errorDeviceCount(Integer errorDeviceCount) {
            this.errorDeviceCount = errorDeviceCount;
            this.changedFields = changedFields.add("errorDeviceCount");
            return this;
        }

        public Builder failedDeviceCount(Integer failedDeviceCount) {
            this.failedDeviceCount = failedDeviceCount;
            this.changedFields = changedFields.add("failedDeviceCount");
            return this;
        }

        public Builder intuneAccountId(String intuneAccountId) {
            this.intuneAccountId = intuneAccountId;
            this.changedFields = changedFields.add("intuneAccountId");
            return this;
        }

        public Builder intuneSettingId(String intuneSettingId) {
            this.intuneSettingId = intuneSettingId;
            this.changedFields = changedFields.add("intuneSettingId");
            return this;
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder notApplicableDeviceCount(Integer notApplicableDeviceCount) {
            this.notApplicableDeviceCount = notApplicableDeviceCount;
            this.changedFields = changedFields.add("notApplicableDeviceCount");
            return this;
        }

        public Builder pendingDeviceCount(Integer pendingDeviceCount) {
            this.pendingDeviceCount = pendingDeviceCount;
            this.changedFields = changedFields.add("pendingDeviceCount");
            return this;
        }

        public Builder policyType(String policyType) {
            this.policyType = policyType;
            this.changedFields = changedFields.add("policyType");
            return this;
        }

        public Builder settingName(String settingName) {
            this.settingName = settingName;
            this.changedFields = changedFields.add("settingName");
            return this;
        }

        public Builder succeededDeviceCount(Integer succeededDeviceCount) {
            this.succeededDeviceCount = succeededDeviceCount;
            this.changedFields = changedFields.add("succeededDeviceCount");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public DeviceCompliancePolicySettingStateSummary build() {
            DeviceCompliancePolicySettingStateSummary _x = new DeviceCompliancePolicySettingStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary";
            _x.id = id;
            _x.conflictDeviceCount = conflictDeviceCount;
            _x.errorDeviceCount = errorDeviceCount;
            _x.failedDeviceCount = failedDeviceCount;
            _x.intuneAccountId = intuneAccountId;
            _x.intuneSettingId = intuneSettingId;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.notApplicableDeviceCount = notApplicableDeviceCount;
            _x.pendingDeviceCount = pendingDeviceCount;
            _x.policyType = policyType;
            _x.settingName = settingName;
            _x.succeededDeviceCount = succeededDeviceCount;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="conflictDeviceCount")
    @JsonIgnore
    public Optional<Integer> getConflictDeviceCount() {
        return Optional.ofNullable(conflictDeviceCount);
    }

    public DeviceCompliancePolicySettingStateSummary withConflictDeviceCount(Integer conflictDeviceCount) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.conflictDeviceCount = conflictDeviceCount;
        return _x;
    }

    @Property(name="errorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getErrorDeviceCount() {
        return Optional.ofNullable(errorDeviceCount);
    }

    public DeviceCompliancePolicySettingStateSummary withErrorDeviceCount(Integer errorDeviceCount) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("errorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.errorDeviceCount = errorDeviceCount;
        return _x;
    }

    @Property(name="failedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getFailedDeviceCount() {
        return Optional.ofNullable(failedDeviceCount);
    }

    public DeviceCompliancePolicySettingStateSummary withFailedDeviceCount(Integer failedDeviceCount) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("failedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.failedDeviceCount = failedDeviceCount;
        return _x;
    }

    @Property(name="intuneAccountId")
    @JsonIgnore
    public Optional<String> getIntuneAccountId() {
        return Optional.ofNullable(intuneAccountId);
    }

    public DeviceCompliancePolicySettingStateSummary withIntuneAccountId(String intuneAccountId) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("intuneAccountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.intuneAccountId = intuneAccountId;
        return _x;
    }

    @Property(name="intuneSettingId")
    @JsonIgnore
    public Optional<String> getIntuneSettingId() {
        return Optional.ofNullable(intuneSettingId);
    }

    public DeviceCompliancePolicySettingStateSummary withIntuneSettingId(String intuneSettingId) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("intuneSettingId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.intuneSettingId = intuneSettingId;
        return _x;
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public DeviceCompliancePolicySettingStateSummary withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="notApplicableDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableDeviceCount() {
        return Optional.ofNullable(notApplicableDeviceCount);
    }

    public DeviceCompliancePolicySettingStateSummary withNotApplicableDeviceCount(Integer notApplicableDeviceCount) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        return _x;
    }

    @Property(name="pendingDeviceCount")
    @JsonIgnore
    public Optional<Integer> getPendingDeviceCount() {
        return Optional.ofNullable(pendingDeviceCount);
    }

    public DeviceCompliancePolicySettingStateSummary withPendingDeviceCount(Integer pendingDeviceCount) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("pendingDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.pendingDeviceCount = pendingDeviceCount;
        return _x;
    }

    @Property(name="policyType")
    @JsonIgnore
    public Optional<String> getPolicyType() {
        return Optional.ofNullable(policyType);
    }

    public DeviceCompliancePolicySettingStateSummary withPolicyType(String policyType) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("policyType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.policyType = policyType;
        return _x;
    }

    @Property(name="settingName")
    @JsonIgnore
    public Optional<String> getSettingName() {
        return Optional.ofNullable(settingName);
    }

    public DeviceCompliancePolicySettingStateSummary withSettingName(String settingName) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("settingName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.settingName = settingName;
        return _x;
    }

    @Property(name="succeededDeviceCount")
    @JsonIgnore
    public Optional<Integer> getSucceededDeviceCount() {
        return Optional.ofNullable(succeededDeviceCount);
    }

    public DeviceCompliancePolicySettingStateSummary withSucceededDeviceCount(Integer succeededDeviceCount) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("succeededDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.succeededDeviceCount = succeededDeviceCount;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public DeviceCompliancePolicySettingStateSummary withTenantDisplayName(String tenantDisplayName) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public DeviceCompliancePolicySettingStateSummary withTenantId(String tenantId) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.deviceCompliancePolicySettingStateSummary");
        _x.tenantId = tenantId;
        return _x;
    }

    public DeviceCompliancePolicySettingStateSummary withUnmappedField(String name, Object value) {
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicySettingStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicySettingStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicySettingStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceCompliancePolicySettingStateSummary _copy() {
        DeviceCompliancePolicySettingStateSummary _x = new DeviceCompliancePolicySettingStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.conflictDeviceCount = conflictDeviceCount;
        _x.errorDeviceCount = errorDeviceCount;
        _x.failedDeviceCount = failedDeviceCount;
        _x.intuneAccountId = intuneAccountId;
        _x.intuneSettingId = intuneSettingId;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        _x.pendingDeviceCount = pendingDeviceCount;
        _x.policyType = policyType;
        _x.settingName = settingName;
        _x.succeededDeviceCount = succeededDeviceCount;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceCompliancePolicySettingStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("conflictDeviceCount=");
        b.append(this.conflictDeviceCount);
        b.append(", ");
        b.append("errorDeviceCount=");
        b.append(this.errorDeviceCount);
        b.append(", ");
        b.append("failedDeviceCount=");
        b.append(this.failedDeviceCount);
        b.append(", ");
        b.append("intuneAccountId=");
        b.append(this.intuneAccountId);
        b.append(", ");
        b.append("intuneSettingId=");
        b.append(this.intuneSettingId);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("notApplicableDeviceCount=");
        b.append(this.notApplicableDeviceCount);
        b.append(", ");
        b.append("pendingDeviceCount=");
        b.append(this.pendingDeviceCount);
        b.append(", ");
        b.append("policyType=");
        b.append(this.policyType);
        b.append(", ");
        b.append("settingName=");
        b.append(this.settingName);
        b.append(", ");
        b.append("succeededDeviceCount=");
        b.append(this.succeededDeviceCount);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
