package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "cloudPcStatus", 
    "displayName", 
    "lastRefreshedDateTime", 
    "managedDeviceId", 
    "managedDeviceName", 
    "provisioningPolicyId", 
    "servicePlanName", 
    "tenantDisplayName", 
    "tenantId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class CloudPcDevice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.cloudPcDevice";
    }

    @JsonProperty("cloudPcStatus")
    protected String cloudPcStatus;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("managedDeviceName")
    protected String managedDeviceName;

    @JsonProperty("provisioningPolicyId")
    protected String provisioningPolicyId;

    @JsonProperty("servicePlanName")
    protected String servicePlanName;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected CloudPcDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String cloudPcStatus;
        private String displayName;
        private OffsetDateTime lastRefreshedDateTime;
        private String managedDeviceId;
        private String managedDeviceName;
        private String provisioningPolicyId;
        private String servicePlanName;
        private String tenantDisplayName;
        private String tenantId;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder cloudPcStatus(String cloudPcStatus) {
            this.cloudPcStatus = cloudPcStatus;
            this.changedFields = changedFields.add("cloudPcStatus");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        public Builder provisioningPolicyId(String provisioningPolicyId) {
            this.provisioningPolicyId = provisioningPolicyId;
            this.changedFields = changedFields.add("provisioningPolicyId");
            return this;
        }

        public Builder servicePlanName(String servicePlanName) {
            this.servicePlanName = servicePlanName;
            this.changedFields = changedFields.add("servicePlanName");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public CloudPcDevice build() {
            CloudPcDevice _x = new CloudPcDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.cloudPcDevice";
            _x.id = id;
            _x.cloudPcStatus = cloudPcStatus;
            _x.displayName = displayName;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.managedDeviceId = managedDeviceId;
            _x.managedDeviceName = managedDeviceName;
            _x.provisioningPolicyId = provisioningPolicyId;
            _x.servicePlanName = servicePlanName;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="cloudPcStatus")
    @JsonIgnore
    public Optional<String> getCloudPcStatus() {
        return Optional.ofNullable(cloudPcStatus);
    }

    public CloudPcDevice withCloudPcStatus(String cloudPcStatus) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("cloudPcStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.cloudPcStatus = cloudPcStatus;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcDevice withDisplayName(String displayName) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public CloudPcDevice withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    public CloudPcDevice withManagedDeviceId(String managedDeviceId) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    @Property(name="managedDeviceName")
    @JsonIgnore
    public Optional<String> getManagedDeviceName() {
        return Optional.ofNullable(managedDeviceName);
    }

    public CloudPcDevice withManagedDeviceName(String managedDeviceName) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.managedDeviceName = managedDeviceName;
        return _x;
    }

    @Property(name="provisioningPolicyId")
    @JsonIgnore
    public Optional<String> getProvisioningPolicyId() {
        return Optional.ofNullable(provisioningPolicyId);
    }

    public CloudPcDevice withProvisioningPolicyId(String provisioningPolicyId) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("provisioningPolicyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.provisioningPolicyId = provisioningPolicyId;
        return _x;
    }

    @Property(name="servicePlanName")
    @JsonIgnore
    public Optional<String> getServicePlanName() {
        return Optional.ofNullable(servicePlanName);
    }

    public CloudPcDevice withServicePlanName(String servicePlanName) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("servicePlanName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.servicePlanName = servicePlanName;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public CloudPcDevice withTenantDisplayName(String tenantDisplayName) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public CloudPcDevice withTenantId(String tenantId) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public CloudPcDevice withUserPrincipalName(String userPrincipalName) {
        CloudPcDevice _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcDevice");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public CloudPcDevice withUnmappedField(String name, Object value) {
        CloudPcDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcDevice _copy() {
        CloudPcDevice _x = new CloudPcDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.cloudPcStatus = cloudPcStatus;
        _x.displayName = displayName;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.managedDeviceId = managedDeviceId;
        _x.managedDeviceName = managedDeviceName;
        _x.provisioningPolicyId = provisioningPolicyId;
        _x.servicePlanName = servicePlanName;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("cloudPcStatus=");
        b.append(this.cloudPcStatus);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("provisioningPolicyId=");
        b.append(this.provisioningPolicyId);
        b.append(", ");
        b.append("servicePlanName=");
        b.append(this.servicePlanName);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
