package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "compliancePolicyId", 
    "compliancePolicyName", 
    "compliancePolicyPlatform", 
    "compliancePolicyType", 
    "lastRefreshedDateTime", 
    "numberOfCompliantDevices", 
    "numberOfErrorDevices", 
    "numberOfNonCompliantDevices", 
    "policyModifiedDateTime", 
    "tenantDisplayName", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class AggregatedPolicyCompliance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.aggregatedPolicyCompliance";
    }

    @JsonProperty("compliancePolicyId")
    protected String compliancePolicyId;

    @JsonProperty("compliancePolicyName")
    protected String compliancePolicyName;

    @JsonProperty("compliancePolicyPlatform")
    protected String compliancePolicyPlatform;

    @JsonProperty("compliancePolicyType")
    protected String compliancePolicyType;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("numberOfCompliantDevices")
    protected Long numberOfCompliantDevices;

    @JsonProperty("numberOfErrorDevices")
    protected Long numberOfErrorDevices;

    @JsonProperty("numberOfNonCompliantDevices")
    protected Long numberOfNonCompliantDevices;

    @JsonProperty("policyModifiedDateTime")
    protected OffsetDateTime policyModifiedDateTime;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected AggregatedPolicyCompliance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAggregatedPolicyCompliance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String compliancePolicyId;
        private String compliancePolicyName;
        private String compliancePolicyPlatform;
        private String compliancePolicyType;
        private OffsetDateTime lastRefreshedDateTime;
        private Long numberOfCompliantDevices;
        private Long numberOfErrorDevices;
        private Long numberOfNonCompliantDevices;
        private OffsetDateTime policyModifiedDateTime;
        private String tenantDisplayName;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder compliancePolicyId(String compliancePolicyId) {
            this.compliancePolicyId = compliancePolicyId;
            this.changedFields = changedFields.add("compliancePolicyId");
            return this;
        }

        public Builder compliancePolicyName(String compliancePolicyName) {
            this.compliancePolicyName = compliancePolicyName;
            this.changedFields = changedFields.add("compliancePolicyName");
            return this;
        }

        public Builder compliancePolicyPlatform(String compliancePolicyPlatform) {
            this.compliancePolicyPlatform = compliancePolicyPlatform;
            this.changedFields = changedFields.add("compliancePolicyPlatform");
            return this;
        }

        public Builder compliancePolicyType(String compliancePolicyType) {
            this.compliancePolicyType = compliancePolicyType;
            this.changedFields = changedFields.add("compliancePolicyType");
            return this;
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder numberOfCompliantDevices(Long numberOfCompliantDevices) {
            this.numberOfCompliantDevices = numberOfCompliantDevices;
            this.changedFields = changedFields.add("numberOfCompliantDevices");
            return this;
        }

        public Builder numberOfErrorDevices(Long numberOfErrorDevices) {
            this.numberOfErrorDevices = numberOfErrorDevices;
            this.changedFields = changedFields.add("numberOfErrorDevices");
            return this;
        }

        public Builder numberOfNonCompliantDevices(Long numberOfNonCompliantDevices) {
            this.numberOfNonCompliantDevices = numberOfNonCompliantDevices;
            this.changedFields = changedFields.add("numberOfNonCompliantDevices");
            return this;
        }

        public Builder policyModifiedDateTime(OffsetDateTime policyModifiedDateTime) {
            this.policyModifiedDateTime = policyModifiedDateTime;
            this.changedFields = changedFields.add("policyModifiedDateTime");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public AggregatedPolicyCompliance build() {
            AggregatedPolicyCompliance _x = new AggregatedPolicyCompliance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.aggregatedPolicyCompliance";
            _x.id = id;
            _x.compliancePolicyId = compliancePolicyId;
            _x.compliancePolicyName = compliancePolicyName;
            _x.compliancePolicyPlatform = compliancePolicyPlatform;
            _x.compliancePolicyType = compliancePolicyType;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.numberOfCompliantDevices = numberOfCompliantDevices;
            _x.numberOfErrorDevices = numberOfErrorDevices;
            _x.numberOfNonCompliantDevices = numberOfNonCompliantDevices;
            _x.policyModifiedDateTime = policyModifiedDateTime;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="compliancePolicyId")
    @JsonIgnore
    public Optional<String> getCompliancePolicyId() {
        return Optional.ofNullable(compliancePolicyId);
    }

    public AggregatedPolicyCompliance withCompliancePolicyId(String compliancePolicyId) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("compliancePolicyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.compliancePolicyId = compliancePolicyId;
        return _x;
    }

    @Property(name="compliancePolicyName")
    @JsonIgnore
    public Optional<String> getCompliancePolicyName() {
        return Optional.ofNullable(compliancePolicyName);
    }

    public AggregatedPolicyCompliance withCompliancePolicyName(String compliancePolicyName) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("compliancePolicyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.compliancePolicyName = compliancePolicyName;
        return _x;
    }

    @Property(name="compliancePolicyPlatform")
    @JsonIgnore
    public Optional<String> getCompliancePolicyPlatform() {
        return Optional.ofNullable(compliancePolicyPlatform);
    }

    public AggregatedPolicyCompliance withCompliancePolicyPlatform(String compliancePolicyPlatform) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("compliancePolicyPlatform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.compliancePolicyPlatform = compliancePolicyPlatform;
        return _x;
    }

    @Property(name="compliancePolicyType")
    @JsonIgnore
    public Optional<String> getCompliancePolicyType() {
        return Optional.ofNullable(compliancePolicyType);
    }

    public AggregatedPolicyCompliance withCompliancePolicyType(String compliancePolicyType) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("compliancePolicyType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.compliancePolicyType = compliancePolicyType;
        return _x;
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public AggregatedPolicyCompliance withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="numberOfCompliantDevices")
    @JsonIgnore
    public Optional<Long> getNumberOfCompliantDevices() {
        return Optional.ofNullable(numberOfCompliantDevices);
    }

    public AggregatedPolicyCompliance withNumberOfCompliantDevices(Long numberOfCompliantDevices) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("numberOfCompliantDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.numberOfCompliantDevices = numberOfCompliantDevices;
        return _x;
    }

    @Property(name="numberOfErrorDevices")
    @JsonIgnore
    public Optional<Long> getNumberOfErrorDevices() {
        return Optional.ofNullable(numberOfErrorDevices);
    }

    public AggregatedPolicyCompliance withNumberOfErrorDevices(Long numberOfErrorDevices) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("numberOfErrorDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.numberOfErrorDevices = numberOfErrorDevices;
        return _x;
    }

    @Property(name="numberOfNonCompliantDevices")
    @JsonIgnore
    public Optional<Long> getNumberOfNonCompliantDevices() {
        return Optional.ofNullable(numberOfNonCompliantDevices);
    }

    public AggregatedPolicyCompliance withNumberOfNonCompliantDevices(Long numberOfNonCompliantDevices) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("numberOfNonCompliantDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.numberOfNonCompliantDevices = numberOfNonCompliantDevices;
        return _x;
    }

    @Property(name="policyModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getPolicyModifiedDateTime() {
        return Optional.ofNullable(policyModifiedDateTime);
    }

    public AggregatedPolicyCompliance withPolicyModifiedDateTime(OffsetDateTime policyModifiedDateTime) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("policyModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.policyModifiedDateTime = policyModifiedDateTime;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public AggregatedPolicyCompliance withTenantDisplayName(String tenantDisplayName) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public AggregatedPolicyCompliance withTenantId(String tenantId) {
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.aggregatedPolicyCompliance");
        _x.tenantId = tenantId;
        return _x;
    }

    public AggregatedPolicyCompliance withUnmappedField(String name, Object value) {
        AggregatedPolicyCompliance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AggregatedPolicyCompliance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AggregatedPolicyCompliance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AggregatedPolicyCompliance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AggregatedPolicyCompliance _copy() {
        AggregatedPolicyCompliance _x = new AggregatedPolicyCompliance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.compliancePolicyId = compliancePolicyId;
        _x.compliancePolicyName = compliancePolicyName;
        _x.compliancePolicyPlatform = compliancePolicyPlatform;
        _x.compliancePolicyType = compliancePolicyType;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.numberOfCompliantDevices = numberOfCompliantDevices;
        _x.numberOfErrorDevices = numberOfErrorDevices;
        _x.numberOfNonCompliantDevices = numberOfNonCompliantDevices;
        _x.policyModifiedDateTime = policyModifiedDateTime;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AggregatedPolicyCompliance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("compliancePolicyId=");
        b.append(this.compliancePolicyId);
        b.append(", ");
        b.append("compliancePolicyName=");
        b.append(this.compliancePolicyName);
        b.append(", ");
        b.append("compliancePolicyPlatform=");
        b.append(this.compliancePolicyPlatform);
        b.append(", ");
        b.append("compliancePolicyType=");
        b.append(this.compliancePolicyType);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("numberOfCompliantDevices=");
        b.append(this.numberOfCompliantDevices);
        b.append(", ");
        b.append("numberOfErrorDevices=");
        b.append(this.numberOfErrorDevices);
        b.append(", ");
        b.append("numberOfNonCompliantDevices=");
        b.append(this.numberOfNonCompliantDevices);
        b.append(", ");
        b.append("policyModifiedDateTime=");
        b.append(this.policyModifiedDateTime);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
