package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.enums.WorkloadOnboardingStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "offboardedDateTime", 
    "onboardedDateTime", 
    "onboardingStatus"})
@JsonInclude(Include.NON_NULL)
public class WorkloadStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("offboardedDateTime")
    protected OffsetDateTime offboardedDateTime;

    @JsonProperty("onboardedDateTime")
    protected OffsetDateTime onboardedDateTime;

    @JsonProperty("onboardingStatus")
    protected WorkloadOnboardingStatus onboardingStatus;

    protected WorkloadStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.workloadStatus";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public WorkloadStatus withDisplayName(String displayName) {
        WorkloadStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadStatus");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="offboardedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOffboardedDateTime() {
        return Optional.ofNullable(offboardedDateTime);
    }

    public WorkloadStatus withOffboardedDateTime(OffsetDateTime offboardedDateTime) {
        WorkloadStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadStatus");
        _x.offboardedDateTime = offboardedDateTime;
        return _x;
    }

    @Property(name="onboardedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnboardedDateTime() {
        return Optional.ofNullable(onboardedDateTime);
    }

    public WorkloadStatus withOnboardedDateTime(OffsetDateTime onboardedDateTime) {
        WorkloadStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadStatus");
        _x.onboardedDateTime = onboardedDateTime;
        return _x;
    }

    @Property(name="onboardingStatus")
    @JsonIgnore
    public Optional<WorkloadOnboardingStatus> getOnboardingStatus() {
        return Optional.ofNullable(onboardingStatus);
    }

    public WorkloadStatus withOnboardingStatus(WorkloadOnboardingStatus onboardingStatus) {
        WorkloadStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadStatus");
        _x.onboardingStatus = onboardingStatus;
        return _x;
    }

    public WorkloadStatus withUnmappedField(String name, Object value) {
        WorkloadStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private OffsetDateTime offboardedDateTime;
        private OffsetDateTime onboardedDateTime;
        private WorkloadOnboardingStatus onboardingStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder offboardedDateTime(OffsetDateTime offboardedDateTime) {
            this.offboardedDateTime = offboardedDateTime;
            this.changedFields = changedFields.add("offboardedDateTime");
            return this;
        }

        public Builder onboardedDateTime(OffsetDateTime onboardedDateTime) {
            this.onboardedDateTime = onboardedDateTime;
            this.changedFields = changedFields.add("onboardedDateTime");
            return this;
        }

        public Builder onboardingStatus(WorkloadOnboardingStatus onboardingStatus) {
            this.onboardingStatus = onboardingStatus;
            this.changedFields = changedFields.add("onboardingStatus");
            return this;
        }

        public WorkloadStatus build() {
            WorkloadStatus _x = new WorkloadStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.workloadStatus";
            _x.displayName = displayName;
            _x.offboardedDateTime = offboardedDateTime;
            _x.onboardedDateTime = onboardedDateTime;
            _x.onboardingStatus = onboardingStatus;
            return _x;
        }
    }

    private WorkloadStatus _copy() {
        WorkloadStatus _x = new WorkloadStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.offboardedDateTime = offboardedDateTime;
        _x.onboardedDateTime = onboardedDateTime;
        _x.onboardingStatus = onboardingStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkloadStatus[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("offboardedDateTime=");
        b.append(this.offboardedDateTime);
        b.append(", ");
        b.append("onboardedDateTime=");
        b.append(this.onboardedDateTime);
        b.append(", ");
        b.append("onboardingStatus=");
        b.append(this.onboardingStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
