package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.GenericError;
import odata.msgraph.client.beta.managed.tenants.enums.WorkloadActionStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "actionId", 
    "deployedPolicyId", 
    "error", 
    "excludeGroups", 
    "includeAllUsers", 
    "includeGroups", 
    "lastDeploymentDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class WorkloadActionDeploymentStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actionId")
    protected String actionId;

    @JsonProperty("deployedPolicyId")
    protected String deployedPolicyId;

    @JsonProperty("error")
    protected GenericError error;

    @JsonProperty("excludeGroups")
    protected List<String> excludeGroups;

    @JsonProperty("excludeGroups@nextLink")
    protected String excludeGroupsNextLink;

    @JsonProperty("includeAllUsers")
    protected Boolean includeAllUsers;

    @JsonProperty("includeGroups")
    protected List<String> includeGroups;

    @JsonProperty("includeGroups@nextLink")
    protected String includeGroupsNextLink;

    @JsonProperty("lastDeploymentDateTime")
    protected OffsetDateTime lastDeploymentDateTime;

    @JsonProperty("status")
    protected WorkloadActionStatus status;

    protected WorkloadActionDeploymentStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.workloadActionDeploymentStatus";
    }

    @Property(name="actionId")
    @JsonIgnore
    public Optional<String> getActionId() {
        return Optional.ofNullable(actionId);
    }

    public WorkloadActionDeploymentStatus withActionId(String actionId) {
        WorkloadActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadActionDeploymentStatus");
        _x.actionId = actionId;
        return _x;
    }

    @Property(name="deployedPolicyId")
    @JsonIgnore
    public Optional<String> getDeployedPolicyId() {
        return Optional.ofNullable(deployedPolicyId);
    }

    public WorkloadActionDeploymentStatus withDeployedPolicyId(String deployedPolicyId) {
        WorkloadActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadActionDeploymentStatus");
        _x.deployedPolicyId = deployedPolicyId;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<GenericError> getError() {
        return Optional.ofNullable(error);
    }

    public WorkloadActionDeploymentStatus withError(GenericError error) {
        WorkloadActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadActionDeploymentStatus");
        _x.error = error;
        return _x;
    }

    @Property(name="excludeGroups")
    @JsonIgnore
    public CollectionPage<String> getExcludeGroups() {
        return new CollectionPage<String>(contextPath, String.class, this.excludeGroups, Optional.ofNullable(excludeGroupsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeGroups")
    @JsonIgnore
    public CollectionPage<String> getExcludeGroups(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.excludeGroups, Optional.ofNullable(excludeGroupsNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeAllUsers")
    @JsonIgnore
    public Optional<Boolean> getIncludeAllUsers() {
        return Optional.ofNullable(includeAllUsers);
    }

    public WorkloadActionDeploymentStatus withIncludeAllUsers(Boolean includeAllUsers) {
        WorkloadActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadActionDeploymentStatus");
        _x.includeAllUsers = includeAllUsers;
        return _x;
    }

    @Property(name="includeGroups")
    @JsonIgnore
    public CollectionPage<String> getIncludeGroups() {
        return new CollectionPage<String>(contextPath, String.class, this.includeGroups, Optional.ofNullable(includeGroupsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeGroups")
    @JsonIgnore
    public CollectionPage<String> getIncludeGroups(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeGroups, Optional.ofNullable(includeGroupsNextLink), Collections.emptyList(), options);
    }

    @Property(name="lastDeploymentDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastDeploymentDateTime() {
        return Optional.ofNullable(lastDeploymentDateTime);
    }

    public WorkloadActionDeploymentStatus withLastDeploymentDateTime(OffsetDateTime lastDeploymentDateTime) {
        WorkloadActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadActionDeploymentStatus");
        _x.lastDeploymentDateTime = lastDeploymentDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<WorkloadActionStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public WorkloadActionDeploymentStatus withStatus(WorkloadActionStatus status) {
        WorkloadActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadActionDeploymentStatus");
        _x.status = status;
        return _x;
    }

    public WorkloadActionDeploymentStatus withUnmappedField(String name, Object value) {
        WorkloadActionDeploymentStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String actionId;
        private String deployedPolicyId;
        private GenericError error;
        private List<String> excludeGroups;
        private String excludeGroupsNextLink;
        private Boolean includeAllUsers;
        private List<String> includeGroups;
        private String includeGroupsNextLink;
        private OffsetDateTime lastDeploymentDateTime;
        private WorkloadActionStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionId(String actionId) {
            this.actionId = actionId;
            this.changedFields = changedFields.add("actionId");
            return this;
        }

        public Builder deployedPolicyId(String deployedPolicyId) {
            this.deployedPolicyId = deployedPolicyId;
            this.changedFields = changedFields.add("deployedPolicyId");
            return this;
        }

        public Builder error(GenericError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder excludeGroups(List<String> excludeGroups) {
            this.excludeGroups = excludeGroups;
            this.changedFields = changedFields.add("excludeGroups");
            return this;
        }

        public Builder excludeGroups(String... excludeGroups) {
            return excludeGroups(Arrays.asList(excludeGroups));
        }

        public Builder excludeGroupsNextLink(String excludeGroupsNextLink) {
            this.excludeGroupsNextLink = excludeGroupsNextLink;
            this.changedFields = changedFields.add("excludeGroups");
            return this;
        }

        public Builder includeAllUsers(Boolean includeAllUsers) {
            this.includeAllUsers = includeAllUsers;
            this.changedFields = changedFields.add("includeAllUsers");
            return this;
        }

        public Builder includeGroups(List<String> includeGroups) {
            this.includeGroups = includeGroups;
            this.changedFields = changedFields.add("includeGroups");
            return this;
        }

        public Builder includeGroups(String... includeGroups) {
            return includeGroups(Arrays.asList(includeGroups));
        }

        public Builder includeGroupsNextLink(String includeGroupsNextLink) {
            this.includeGroupsNextLink = includeGroupsNextLink;
            this.changedFields = changedFields.add("includeGroups");
            return this;
        }

        public Builder lastDeploymentDateTime(OffsetDateTime lastDeploymentDateTime) {
            this.lastDeploymentDateTime = lastDeploymentDateTime;
            this.changedFields = changedFields.add("lastDeploymentDateTime");
            return this;
        }

        public Builder status(WorkloadActionStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public WorkloadActionDeploymentStatus build() {
            WorkloadActionDeploymentStatus _x = new WorkloadActionDeploymentStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.workloadActionDeploymentStatus";
            _x.actionId = actionId;
            _x.deployedPolicyId = deployedPolicyId;
            _x.error = error;
            _x.excludeGroups = excludeGroups;
            _x.excludeGroupsNextLink = excludeGroupsNextLink;
            _x.includeAllUsers = includeAllUsers;
            _x.includeGroups = includeGroups;
            _x.includeGroupsNextLink = includeGroupsNextLink;
            _x.lastDeploymentDateTime = lastDeploymentDateTime;
            _x.status = status;
            return _x;
        }
    }

    private WorkloadActionDeploymentStatus _copy() {
        WorkloadActionDeploymentStatus _x = new WorkloadActionDeploymentStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionId = actionId;
        _x.deployedPolicyId = deployedPolicyId;
        _x.error = error;
        _x.excludeGroups = excludeGroups;
        _x.includeAllUsers = includeAllUsers;
        _x.includeGroups = includeGroups;
        _x.lastDeploymentDateTime = lastDeploymentDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkloadActionDeploymentStatus[");
        b.append("actionId=");
        b.append(this.actionId);
        b.append(", ");
        b.append("deployedPolicyId=");
        b.append(this.deployedPolicyId);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("excludeGroups=");
        b.append(this.excludeGroups);
        b.append(", ");
        b.append("includeAllUsers=");
        b.append(this.includeAllUsers);
        b.append(", ");
        b.append("includeGroups=");
        b.append(this.includeGroups);
        b.append(", ");
        b.append("lastDeploymentDateTime=");
        b.append(this.lastDeploymentDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
