package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.enums.WorkloadActionCategory;

@JsonPropertyOrder({
    "@odata.type", 
    "actionId", 
    "category", 
    "description", 
    "displayName", 
    "licenses", 
    "service", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class WorkloadAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actionId")
    protected String actionId;

    @JsonProperty("category")
    protected WorkloadActionCategory category;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("licenses")
    protected List<String> licenses;

    @JsonProperty("licenses@nextLink")
    protected String licensesNextLink;

    @JsonProperty("service")
    protected String service;

    @JsonProperty("settings")
    protected List<Setting> settings;

    @JsonProperty("settings@nextLink")
    protected String settingsNextLink;

    protected WorkloadAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.workloadAction";
    }

    @Property(name="actionId")
    @JsonIgnore
    public Optional<String> getActionId() {
        return Optional.ofNullable(actionId);
    }

    public WorkloadAction withActionId(String actionId) {
        WorkloadAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadAction");
        _x.actionId = actionId;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<WorkloadActionCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public WorkloadAction withCategory(WorkloadActionCategory category) {
        WorkloadAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadAction");
        _x.category = category;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public WorkloadAction withDescription(String description) {
        WorkloadAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadAction");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public WorkloadAction withDisplayName(String displayName) {
        WorkloadAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadAction");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="licenses")
    @JsonIgnore
    public CollectionPage<String> getLicenses() {
        return new CollectionPage<String>(contextPath, String.class, this.licenses, Optional.ofNullable(licensesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="licenses")
    @JsonIgnore
    public CollectionPage<String> getLicenses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.licenses, Optional.ofNullable(licensesNextLink), Collections.emptyList(), options);
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public WorkloadAction withService(String service) {
        WorkloadAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.workloadAction");
        _x.service = service;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public CollectionPage<Setting> getSettings() {
        return new CollectionPage<Setting>(contextPath, Setting.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="settings")
    @JsonIgnore
    public CollectionPage<Setting> getSettings(HttpRequestOptions options) {
        return new CollectionPage<Setting>(contextPath, Setting.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), options);
    }

    public WorkloadAction withUnmappedField(String name, Object value) {
        WorkloadAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String actionId;
        private WorkloadActionCategory category;
        private String description;
        private String displayName;
        private List<String> licenses;
        private String licensesNextLink;
        private String service;
        private List<Setting> settings;
        private String settingsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionId(String actionId) {
            this.actionId = actionId;
            this.changedFields = changedFields.add("actionId");
            return this;
        }

        public Builder category(WorkloadActionCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder licenses(List<String> licenses) {
            this.licenses = licenses;
            this.changedFields = changedFields.add("licenses");
            return this;
        }

        public Builder licenses(String... licenses) {
            return licenses(Arrays.asList(licenses));
        }

        public Builder licensesNextLink(String licensesNextLink) {
            this.licensesNextLink = licensesNextLink;
            this.changedFields = changedFields.add("licenses");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public Builder settings(List<Setting> settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder settings(Setting... settings) {
            return settings(Arrays.asList(settings));
        }

        public Builder settingsNextLink(String settingsNextLink) {
            this.settingsNextLink = settingsNextLink;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public WorkloadAction build() {
            WorkloadAction _x = new WorkloadAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.workloadAction";
            _x.actionId = actionId;
            _x.category = category;
            _x.description = description;
            _x.displayName = displayName;
            _x.licenses = licenses;
            _x.licensesNextLink = licensesNextLink;
            _x.service = service;
            _x.settings = settings;
            _x.settingsNextLink = settingsNextLink;
            return _x;
        }
    }

    private WorkloadAction _copy() {
        WorkloadAction _x = new WorkloadAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionId = actionId;
        _x.category = category;
        _x.description = description;
        _x.displayName = displayName;
        _x.licenses = licenses;
        _x.service = service;
        _x.settings = settings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkloadAction[");
        b.append("actionId=");
        b.append(this.actionId);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("licenses=");
        b.append(this.licenses);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
