package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "email", 
    "name", 
    "notes", 
    "phone", 
    "title"})
@JsonInclude(Include.NON_NULL)
public class TenantContactInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("phone")
    protected String phone;

    @JsonProperty("title")
    protected String title;

    protected TenantContactInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.tenantContactInformation";
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public TenantContactInformation withEmail(String email) {
        TenantContactInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantContactInformation");
        _x.email = email;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public TenantContactInformation withName(String name) {
        TenantContactInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantContactInformation");
        _x.name = name;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    public TenantContactInformation withNotes(String notes) {
        TenantContactInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantContactInformation");
        _x.notes = notes;
        return _x;
    }

    @Property(name="phone")
    @JsonIgnore
    public Optional<String> getPhone() {
        return Optional.ofNullable(phone);
    }

    public TenantContactInformation withPhone(String phone) {
        TenantContactInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantContactInformation");
        _x.phone = phone;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public TenantContactInformation withTitle(String title) {
        TenantContactInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantContactInformation");
        _x.title = title;
        return _x;
    }

    public TenantContactInformation withUnmappedField(String name, Object value) {
        TenantContactInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String email;
        private String name;
        private String notes;
        private String phone;
        private String title;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            this.changedFields = changedFields.add("phone");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public TenantContactInformation build() {
            TenantContactInformation _x = new TenantContactInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.tenantContactInformation";
            _x.email = email;
            _x.name = name;
            _x.notes = notes;
            _x.phone = phone;
            _x.title = title;
            return _x;
        }
    }

    private TenantContactInformation _copy() {
        TenantContactInformation _x = new TenantContactInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.email = email;
        _x.name = name;
        _x.notes = notes;
        _x.phone = phone;
        _x.title = title;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantContactInformation[");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("phone=");
        b.append(this.phone);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
