package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "errorDetails", 
    "nodeId", 
    "rawToken", 
    "statementIndex"})
@JsonInclude(Include.NON_NULL)
public class ManagedTenantExecutionError extends ManagedTenantOperationError implements ODataType {

    @JsonProperty("errorDetails")
    protected String errorDetails;

    @JsonProperty("nodeId")
    protected Integer nodeId;

    @JsonProperty("rawToken")
    protected String rawToken;

    @JsonProperty("statementIndex")
    protected Integer statementIndex;

    protected ManagedTenantExecutionError() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managedTenantExecutionError";
    }

    @Property(name="errorDetails")
    @JsonIgnore
    public Optional<String> getErrorDetails() {
        return Optional.ofNullable(errorDetails);
    }

    public ManagedTenantExecutionError withErrorDetails(String errorDetails) {
        ManagedTenantExecutionError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenantExecutionError");
        _x.errorDetails = errorDetails;
        return _x;
    }

    @Property(name="nodeId")
    @JsonIgnore
    public Optional<Integer> getNodeId() {
        return Optional.ofNullable(nodeId);
    }

    public ManagedTenantExecutionError withNodeId(Integer nodeId) {
        ManagedTenantExecutionError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenantExecutionError");
        _x.nodeId = nodeId;
        return _x;
    }

    @Property(name="rawToken")
    @JsonIgnore
    public Optional<String> getRawToken() {
        return Optional.ofNullable(rawToken);
    }

    public ManagedTenantExecutionError withRawToken(String rawToken) {
        ManagedTenantExecutionError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenantExecutionError");
        _x.rawToken = rawToken;
        return _x;
    }

    @Property(name="statementIndex")
    @JsonIgnore
    public Optional<Integer> getStatementIndex() {
        return Optional.ofNullable(statementIndex);
    }

    public ManagedTenantExecutionError withStatementIndex(Integer statementIndex) {
        ManagedTenantExecutionError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenantExecutionError");
        _x.statementIndex = statementIndex;
        return _x;
    }

    public ManagedTenantExecutionError withUnmappedField(String name, Object value) {
        ManagedTenantExecutionError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedTenantExecutionError() {
        return new Builder();
    }

    public static final class Builder {
        private String error;
        private String tenantId;
        private String errorDetails;
        private Integer nodeId;
        private String rawToken;
        private Integer statementIndex;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder error(String error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            this.changedFields = changedFields.add("errorDetails");
            return this;
        }

        public Builder nodeId(Integer nodeId) {
            this.nodeId = nodeId;
            this.changedFields = changedFields.add("nodeId");
            return this;
        }

        public Builder rawToken(String rawToken) {
            this.rawToken = rawToken;
            this.changedFields = changedFields.add("rawToken");
            return this;
        }

        public Builder statementIndex(Integer statementIndex) {
            this.statementIndex = statementIndex;
            this.changedFields = changedFields.add("statementIndex");
            return this;
        }

        public ManagedTenantExecutionError build() {
            ManagedTenantExecutionError _x = new ManagedTenantExecutionError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managedTenantExecutionError";
            _x.error = error;
            _x.tenantId = tenantId;
            _x.errorDetails = errorDetails;
            _x.nodeId = nodeId;
            _x.rawToken = rawToken;
            _x.statementIndex = statementIndex;
            return _x;
        }
    }

    private ManagedTenantExecutionError _copy() {
        ManagedTenantExecutionError _x = new ManagedTenantExecutionError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.error = error;
        _x.tenantId = tenantId;
        _x.errorDetails = errorDetails;
        _x.nodeId = nodeId;
        _x.rawToken = rawToken;
        _x.statementIndex = statementIndex;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedTenantExecutionError[");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("errorDetails=");
        b.append(this.errorDetails);
        b.append(", ");
        b.append("nodeId=");
        b.append(this.nodeId);
        b.append(", ");
        b.append("rawToken=");
        b.append(this.rawToken);
        b.append(", ");
        b.append("statementIndex=");
        b.append(this.statementIndex);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
