package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum X509CertificateAuthenticationMode implements Enum {

    @JsonProperty("x509CertificateSingleFactor")
    X509CERTIFICATE_SINGLE_FACTOR("x509CertificateSingleFactor", "0"),

    @JsonProperty("x509CertificateMultiFactor")
    X509CERTIFICATE_MULTI_FACTOR("x509CertificateMultiFactor", "1"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "2");

    private final String name;
    private final String value;

    private X509CertificateAuthenticationMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
