package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WiredNetworkInterface implements Enum {

    @JsonProperty("anyEthernet")
    ANY_ETHERNET("anyEthernet", "0"),

    @JsonProperty("firstActiveEthernet")
    FIRST_ACTIVE_ETHERNET("firstActiveEthernet", "1"),

    @JsonProperty("secondActiveEthernet")
    SECOND_ACTIVE_ETHERNET("secondActiveEthernet", "2"),

    @JsonProperty("thirdActiveEthernet")
    THIRD_ACTIVE_ETHERNET("thirdActiveEthernet", "3"),

    @JsonProperty("firstEthernet")
    FIRST_ETHERNET("firstEthernet", "4"),

    @JsonProperty("secondEthernet")
    SECOND_ETHERNET("secondEthernet", "5"),

    @JsonProperty("thirdEthernet")
    THIRD_ETHERNET("thirdEthernet", "6");

    private final String name;
    private final String value;

    private WiredNetworkInterface(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
