package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsVpnConnectionType implements Enum {

    @JsonProperty("pulseSecure")
    PULSE_SECURE("pulseSecure", "0"),

    @JsonProperty("f5EdgeClient")
    F5EDGE_CLIENT("f5EdgeClient", "1"),

    @JsonProperty("dellSonicWallMobileConnect")
    DELL_SONIC_WALL_MOBILE_CONNECT("dellSonicWallMobileConnect", "2"),

    @JsonProperty("checkPointCapsuleVpn")
    CHECK_POINT_CAPSULE_VPN("checkPointCapsuleVpn", "3");

    private final String name;
    private final String value;

    private WindowsVpnConnectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
