package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsUserAccountControlSettings implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("alwaysNotify")
    ALWAYS_NOTIFY("alwaysNotify", "1"),

    @JsonProperty("notifyOnAppChanges")
    NOTIFY_ON_APP_CHANGES("notifyOnAppChanges", "2"),

    @JsonProperty("notifyOnAppChangesWithoutDimming")
    NOTIFY_ON_APP_CHANGES_WITHOUT_DIMMING("notifyOnAppChangesWithoutDimming", "3"),

    @JsonProperty("neverNotify")
    NEVER_NOTIFY("neverNotify", "4");

    private final String name;
    private final String value;

    private WindowsUserAccountControlSettings(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
