package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsUpdateType implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("all")
    ALL("all", "1"),

    @JsonProperty("businessReadyOnly")
    BUSINESS_READY_ONLY("businessReadyOnly", "2"),

    @JsonProperty("windowsInsiderBuildFast")
    WINDOWS_INSIDER_BUILD_FAST("windowsInsiderBuildFast", "3"),

    @JsonProperty("windowsInsiderBuildSlow")
    WINDOWS_INSIDER_BUILD_SLOW("windowsInsiderBuildSlow", "4"),

    @JsonProperty("windowsInsiderBuildRelease")
    WINDOWS_INSIDER_BUILD_RELEASE("windowsInsiderBuildRelease", "5");

    private final String name;
    private final String value;

    private WindowsUpdateType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
