package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsUpdateNotificationDisplayOption implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("defaultNotifications")
    DEFAULT_NOTIFICATIONS("defaultNotifications", "1"),

    @JsonProperty("restartWarningsOnly")
    RESTART_WARNINGS_ONLY("restartWarningsOnly", "2"),

    @JsonProperty("disableAllNotifications")
    DISABLE_ALL_NOTIFICATIONS("disableAllNotifications", "3");

    private final String name;
    private final String value;

    private WindowsUpdateNotificationDisplayOption(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
