package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsStartMenuAppListVisibilityType implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("collapse")
    COLLAPSE("collapse", "1"),

    @JsonProperty("remove")
    REMOVE("remove", "2"),

    @JsonProperty("disableSettingsApp")
    DISABLE_SETTINGS_APP("disableSettingsApp", "4");

    private final String name;
    private final String value;

    private WindowsStartMenuAppListVisibilityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
