package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsPrivacyDataAccessLevel implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("forceAllow")
    FORCE_ALLOW("forceAllow", "1"),

    @JsonProperty("forceDeny")
    FORCE_DENY("forceDeny", "2"),

    @JsonProperty("userInControl")
    USER_IN_CONTROL("userInControl", "3");

    private final String name;
    private final String value;

    private WindowsPrivacyDataAccessLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
