package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsMalwareThreatState implements Enum {

    @JsonProperty("active")
    ACTIVE("active", "0"),

    @JsonProperty("actionFailed")
    ACTION_FAILED("actionFailed", "1"),

    @JsonProperty("manualStepsRequired")
    MANUAL_STEPS_REQUIRED("manualStepsRequired", "2"),

    @JsonProperty("fullScanRequired")
    FULL_SCAN_REQUIRED("fullScanRequired", "3"),

    @JsonProperty("rebootRequired")
    REBOOT_REQUIRED("rebootRequired", "4"),

    @JsonProperty("remediatedWithNonCriticalFailures")
    REMEDIATED_WITH_NON_CRITICAL_FAILURES("remediatedWithNonCriticalFailures", "5"),

    @JsonProperty("quarantined")
    QUARANTINED("quarantined", "6"),

    @JsonProperty("removed")
    REMOVED("removed", "7"),

    @JsonProperty("cleaned")
    CLEANED("cleaned", "8"),

    @JsonProperty("allowed")
    ALLOWED("allowed", "9"),

    @JsonProperty("noStatusCleared")
    NO_STATUS_CLEARED("noStatusCleared", "10");

    private final String name;
    private final String value;

    private WindowsMalwareThreatState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
