package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsMalwareExecutionState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "1"),

    @JsonProperty("allowed")
    ALLOWED("allowed", "2"),

    @JsonProperty("running")
    RUNNING("running", "3"),

    @JsonProperty("notRunning")
    NOT_RUNNING("notRunning", "4");

    private final String name;
    private final String value;

    private WindowsMalwareExecutionState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
