package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsMalwareCategory implements Enum {

    @JsonProperty("invalid")
    INVALID("invalid", "0"),

    @JsonProperty("adware")
    ADWARE("adware", "1"),

    @JsonProperty("spyware")
    SPYWARE("spyware", "2"),

    @JsonProperty("passwordStealer")
    PASSWORD_STEALER("passwordStealer", "3"),

    @JsonProperty("trojanDownloader")
    TROJAN_DOWNLOADER("trojanDownloader", "4"),

    @JsonProperty("worm")
    WORM("worm", "5"),

    @JsonProperty("backdoor")
    BACKDOOR("backdoor", "6"),

    @JsonProperty("remoteAccessTrojan")
    REMOTE_ACCESS_TROJAN("remoteAccessTrojan", "7"),

    @JsonProperty("trojan")
    TROJAN("trojan", "8"),

    @JsonProperty("emailFlooder")
    EMAIL_FLOODER("emailFlooder", "9"),

    @JsonProperty("keylogger")
    KEYLOGGER("keylogger", "10"),

    @JsonProperty("dialer")
    DIALER("dialer", "11"),

    @JsonProperty("monitoringSoftware")
    MONITORING_SOFTWARE("monitoringSoftware", "12"),

    @JsonProperty("browserModifier")
    BROWSER_MODIFIER("browserModifier", "13"),

    @JsonProperty("cookie")
    COOKIE("cookie", "14"),

    @JsonProperty("browserPlugin")
    BROWSER_PLUGIN("browserPlugin", "15"),

    @JsonProperty("aolExploit")
    AOL_EXPLOIT("aolExploit", "16"),

    @JsonProperty("nuker")
    NUKER("nuker", "17"),

    @JsonProperty("securityDisabler")
    SECURITY_DISABLER("securityDisabler", "18"),

    @JsonProperty("jokeProgram")
    JOKE_PROGRAM("jokeProgram", "19"),

    @JsonProperty("hostileActiveXControl")
    HOSTILE_ACTIVE_XCONTROL("hostileActiveXControl", "20"),

    @JsonProperty("softwareBundler")
    SOFTWARE_BUNDLER("softwareBundler", "21"),

    @JsonProperty("stealthNotifier")
    STEALTH_NOTIFIER("stealthNotifier", "22"),

    @JsonProperty("settingsModifier")
    SETTINGS_MODIFIER("settingsModifier", "23"),

    @JsonProperty("toolBar")
    TOOL_BAR("toolBar", "24"),

    @JsonProperty("remoteControlSoftware")
    REMOTE_CONTROL_SOFTWARE("remoteControlSoftware", "25"),

    @JsonProperty("trojanFtp")
    TROJAN_FTP("trojanFtp", "26"),

    @JsonProperty("potentialUnwantedSoftware")
    POTENTIAL_UNWANTED_SOFTWARE("potentialUnwantedSoftware", "27"),

    @JsonProperty("icqExploit")
    ICQ_EXPLOIT("icqExploit", "28"),

    @JsonProperty("trojanTelnet")
    TROJAN_TELNET("trojanTelnet", "29"),

    @JsonProperty("exploit")
    EXPLOIT("exploit", "30"),

    @JsonProperty("filesharingProgram")
    FILESHARING_PROGRAM("filesharingProgram", "31"),

    @JsonProperty("malwareCreationTool")
    MALWARE_CREATION_TOOL("malwareCreationTool", "32"),

    @JsonProperty("remote_Control_Software")
    REMOTE_CONTROL_SOFTWARE1("remote_Control_Software", "33"),

    @JsonProperty("tool")
    TOOL("tool", "34"),

    @JsonProperty("trojanDenialOfService")
    TROJAN_DENIAL_OF_SERVICE("trojanDenialOfService", "36"),

    @JsonProperty("trojanDropper")
    TROJAN_DROPPER("trojanDropper", "37"),

    @JsonProperty("trojanMassMailer")
    TROJAN_MASS_MAILER("trojanMassMailer", "38"),

    @JsonProperty("trojanMonitoringSoftware")
    TROJAN_MONITORING_SOFTWARE("trojanMonitoringSoftware", "39"),

    @JsonProperty("trojanProxyServer")
    TROJAN_PROXY_SERVER("trojanProxyServer", "40"),

    @JsonProperty("virus")
    VIRUS("virus", "42"),

    @JsonProperty("known")
    KNOWN("known", "43"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "44"),

    @JsonProperty("spp")
    SPP("spp", "45"),

    @JsonProperty("behavior")
    BEHAVIOR("behavior", "46"),

    @JsonProperty("vulnerability")
    VULNERABILITY("vulnerability", "47"),

    @JsonProperty("policy")
    POLICY("policy", "48"),

    @JsonProperty("enterpriseUnwantedSoftware")
    ENTERPRISE_UNWANTED_SOFTWARE("enterpriseUnwantedSoftware", "49"),

    @JsonProperty("ransom")
    RANSOM("ransom", "50"),

    @JsonProperty("hipsRule")
    HIPS_RULE("hipsRule", "51");

    private final String name;
    private final String value;

    private WindowsMalwareCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
