package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsKioskAppType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("store")
    STORE("store", "1"),

    @JsonProperty("desktop")
    DESKTOP("desktop", "2"),

    @JsonProperty("aumId")
    AUM_ID("aumId", "3");

    private final String name;
    private final String value;

    private WindowsKioskAppType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
