package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsFirewallRuleInterfaceTypes implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("remoteAccess")
    REMOTE_ACCESS("remoteAccess", "1"),

    @JsonProperty("wireless")
    WIRELESS("wireless", "2"),

    @JsonProperty("lan")
    LAN("lan", "4");

    private final String name;
    private final String value;

    private WindowsFirewallRuleInterfaceTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
