package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsDefenderApplicationControlSupplementalPolicyStatuses implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("success")
    SUCCESS("success", "1"),

    @JsonProperty("tokenError")
    TOKEN_ERROR("tokenError", "2"),

    @JsonProperty("notAuthorizedByToken")
    NOT_AUTHORIZED_BY_TOKEN("notAuthorizedByToken", "3"),

    @JsonProperty("policyNotFound")
    POLICY_NOT_FOUND("policyNotFound", "4");

    private final String name;
    private final String value;

    private WindowsDefenderApplicationControlSupplementalPolicyStatuses(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
