package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsAutopilotProfileAssignmentDetailedStatus implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("hardwareRequirementsNotMet")
    HARDWARE_REQUIREMENTS_NOT_MET("hardwareRequirementsNotMet", "1"),

    @JsonProperty("surfaceHubProfileNotSupported")
    SURFACE_HUB_PROFILE_NOT_SUPPORTED("surfaceHubProfileNotSupported", "2"),

    @JsonProperty("holoLensProfileNotSupported")
    HOLO_LENS_PROFILE_NOT_SUPPORTED("holoLensProfileNotSupported", "3"),

    @JsonProperty("windowsPcProfileNotSupported")
    WINDOWS_PC_PROFILE_NOT_SUPPORTED("windowsPcProfileNotSupported", "4"),

    @JsonProperty("surfaceHub2SProfileNotSupported")
    SURFACE_HUB2SPROFILE_NOT_SUPPORTED("surfaceHub2SProfileNotSupported", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "99");

    private final String name;
    private final String value;

    private WindowsAutopilotProfileAssignmentDetailedStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
