package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsAutopilotDeviceType implements Enum {

    @JsonProperty("windowsPc")
    WINDOWS_PC("windowsPc", "0"),

    @JsonProperty("surfaceHub2")
    SURFACE_HUB2("surfaceHub2", "1"),

    @JsonProperty("holoLens")
    HOLO_LENS("holoLens", "2"),

    @JsonProperty("surfaceHub2S")
    SURFACE_HUB2S("surfaceHub2S", "3"),

    @JsonProperty("virtualMachine")
    VIRTUAL_MACHINE("virtualMachine", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "99");

    private final String name;
    private final String value;

    private WindowsAutopilotDeviceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
