package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Windows10VpnConnectionType implements Enum {

    @JsonProperty("pulseSecure")
    PULSE_SECURE("pulseSecure", "0"),

    @JsonProperty("f5EdgeClient")
    F5EDGE_CLIENT("f5EdgeClient", "1"),

    @JsonProperty("dellSonicWallMobileConnect")
    DELL_SONIC_WALL_MOBILE_CONNECT("dellSonicWallMobileConnect", "2"),

    @JsonProperty("checkPointCapsuleVpn")
    CHECK_POINT_CAPSULE_VPN("checkPointCapsuleVpn", "3"),

    @JsonProperty("automatic")
    AUTOMATIC("automatic", "4"),

    @JsonProperty("ikEv2")
    IK_EV2("ikEv2", "5"),

    @JsonProperty("l2tp")
    L2TP("l2tp", "6"),

    @JsonProperty("pptp")
    PPTP("pptp", "7"),

    @JsonProperty("citrix")
    CITRIX("citrix", "8"),

    @JsonProperty("paloAltoGlobalProtect")
    PALO_ALTO_GLOBAL_PROTECT("paloAltoGlobalProtect", "9"),

    @JsonProperty("ciscoAnyConnect")
    CISCO_ANY_CONNECT("ciscoAnyConnect", "10"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "11"),

    @JsonProperty("microsoftTunnel")
    MICROSOFT_TUNNEL("microsoftTunnel", "12");

    private final String name;
    private final String value;

    private Windows10VpnConnectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
