package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Win32LobAppRuleType implements Enum {

    @JsonProperty("detection")
    DETECTION("detection", "0"),

    @JsonProperty("requirement")
    REQUIREMENT("requirement", "1");

    private final String name;
    private final String value;

    private Win32LobAppRuleType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
