package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Win32LobAppRegistryDetectionType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("exists")
    EXISTS("exists", "1"),

    @JsonProperty("doesNotExist")
    DOES_NOT_EXIST("doesNotExist", "2"),

    @JsonProperty("string")
    STRING("string", "3"),

    @JsonProperty("integer")
    INTEGER("integer", "4"),

    @JsonProperty("version")
    VERSION("version", "5");

    private final String name;
    private final String value;

    private Win32LobAppRegistryDetectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
