package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WellKnownListName_v2 implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("defaultList")
    DEFAULT_LIST("defaultList", "1"),

    @JsonProperty("flaggedEmails")
    FLAGGED_EMAILS("flaggedEmails", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private WellKnownListName_v2(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
