package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WebBrowserCookieSettings implements Enum {

    @JsonProperty("browserDefault")
    BROWSER_DEFAULT("browserDefault", "0"),

    @JsonProperty("blockAlways")
    BLOCK_ALWAYS("blockAlways", "1"),

    @JsonProperty("allowCurrentWebSite")
    ALLOW_CURRENT_WEB_SITE("allowCurrentWebSite", "2"),

    @JsonProperty("allowFromWebsitesVisited")
    ALLOW_FROM_WEBSITES_VISITED("allowFromWebsitesVisited", "3"),

    @JsonProperty("allowAlways")
    ALLOW_ALWAYS("allowAlways", "4");

    private final String name;
    private final String value;

    private WebBrowserCookieSettings(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
