package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum VpnServiceExceptionAction implements Enum {

    @JsonProperty("forceTrafficViaVPN")
    FORCE_TRAFFIC_VIA_VPN("forceTrafficViaVPN", "0"),

    @JsonProperty("allowTrafficOutside")
    ALLOW_TRAFFIC_OUTSIDE("allowTrafficOutside", "1"),

    @JsonProperty("dropTraffic")
    DROP_TRAFFIC("dropTraffic", "2");

    private final String name;
    private final String value;

    private VpnServiceExceptionAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
