package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum VpnDeadPeerDetectionRate implements Enum {

    @JsonProperty("medium")
    MEDIUM("medium", "0"),

    @JsonProperty("none")
    NONE("none", "1"),

    @JsonProperty("low")
    LOW("low", "2"),

    @JsonProperty("high")
    HIGH("high", "3");

    private final String name;
    private final String value;

    private VpnDeadPeerDetectionRate(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
