package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum UserExperienceAnalyticsSummarizedBy implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("model")
    MODEL("model", "1"),

    @JsonProperty("allRegressions")
    ALL_REGRESSIONS("allRegressions", "3"),

    @JsonProperty("modelRegression")
    MODEL_REGRESSION("modelRegression", "4"),

    @JsonProperty("manufacturerRegression")
    MANUFACTURER_REGRESSION("manufacturerRegression", "5"),

    @JsonProperty("operatingSystemVersionRegression")
    OPERATING_SYSTEM_VERSION_REGRESSION("operatingSystemVersionRegression", "6");

    private final String name;
    private final String value;

    private UserExperienceAnalyticsSummarizedBy(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
