package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum UsageRightState implements Enum {

    @JsonProperty("active")
    ACTIVE("active", "0"),

    @JsonProperty("inactive")
    INACTIVE("inactive", "1"),

    @JsonProperty("warning")
    WARNING("warning", "2"),

    @JsonProperty("suspended")
    SUSPENDED("suspended", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private UsageRightState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
