package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ThreatCategory implements Enum {

    @JsonProperty("undefined")
    UNDEFINED("undefined", "0"),

    @JsonProperty("spam")
    SPAM("spam", "1"),

    @JsonProperty("phishing")
    PHISHING("phishing", "2"),

    @JsonProperty("malware")
    MALWARE("malware", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private ThreatCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
