package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ThreatAssessmentStatus implements Enum {

    @JsonProperty("pending")
    PENDING("pending", "1"),

    @JsonProperty("completed")
    COMPLETED("completed", "2");

    private final String name;
    private final String value;

    private ThreatAssessmentStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
