package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ThreatAssessmentContentType implements Enum {

    @JsonProperty("mail")
    MAIL("mail", "1"),

    @JsonProperty("url")
    URL("url", "2"),

    @JsonProperty("file")
    FILE("file", "3");

    private final String name;
    private final String value;

    private ThreatAssessmentContentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
