package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamworkUserIdentityType implements Enum {

    @JsonProperty("aadUser")
    AAD_USER("aadUser", "0"),

    @JsonProperty("onPremiseAadUser")
    ON_PREMISE_AAD_USER("onPremiseAadUser", "1"),

    @JsonProperty("anonymousGuest")
    ANONYMOUS_GUEST("anonymousGuest", "2"),

    @JsonProperty("federatedUser")
    FEDERATED_USER("federatedUser", "3"),

    @JsonProperty("personalMicrosoftAccountUser")
    PERSONAL_MICROSOFT_ACCOUNT_USER("personalMicrosoftAccountUser", "4"),

    @JsonProperty("skypeUser")
    SKYPE_USER("skypeUser", "5"),

    @JsonProperty("phoneUser")
    PHONE_USER("phoneUser", "6"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private TeamworkUserIdentityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
