package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamworkDeviceActivityState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("busy")
    BUSY("busy", "1"),

    @JsonProperty("idle")
    IDLE("idle", "2"),

    @JsonProperty("unavailable")
    UNAVAILABLE("unavailable", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private TeamworkDeviceActivityState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
