package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamworkApplicationIdentityType implements Enum {

    @JsonProperty("aadApplication")
    AAD_APPLICATION("aadApplication", "0"),

    @JsonProperty("bot")
    BOT("bot", "1"),

    @JsonProperty("tenantBot")
    TENANT_BOT("tenantBot", "2"),

    @JsonProperty("office365Connector")
    OFFICE365CONNECTOR("office365Connector", "3"),

    @JsonProperty("outgoingWebhook")
    OUTGOING_WEBHOOK("outgoingWebhook", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private TeamworkApplicationIdentityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
