package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamworkActivityTopicSource implements Enum {

    @JsonProperty("entityUrl")
    ENTITY_URL("entityUrl", "0"),

    @JsonProperty("text")
    TEXT("text", "1");

    private final String name;
    private final String value;

    private TeamworkActivityTopicSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
