package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamsAsyncOperationType implements Enum {

    @JsonProperty("invalid")
    INVALID("invalid", "0"),

    @JsonProperty("cloneTeam")
    CLONE_TEAM("cloneTeam", "1"),

    @JsonProperty("archiveTeam")
    ARCHIVE_TEAM("archiveTeam", "2"),

    @JsonProperty("unarchiveTeam")
    UNARCHIVE_TEAM("unarchiveTeam", "3"),

    @JsonProperty("createTeam")
    CREATE_TEAM("createTeam", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5"),

    @JsonProperty("teamifyGroup")
    TEAMIFY_GROUP("teamifyGroup", "6"),

    @JsonProperty("createChannel")
    CREATE_CHANNEL("createChannel", "7"),

    @JsonProperty("createChat")
    CREATE_CHAT("createChat", "8");

    private final String name;
    private final String value;

    private TeamsAsyncOperationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
