package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TargetedManagedAppGroupType implements Enum {

    @JsonProperty("selectedPublicApps")
    SELECTED_PUBLIC_APPS("selectedPublicApps", "0"),

    @JsonProperty("allCoreMicrosoftApps")
    ALL_CORE_MICROSOFT_APPS("allCoreMicrosoftApps", "1"),

    @JsonProperty("allMicrosoftApps")
    ALL_MICROSOFT_APPS("allMicrosoftApps", "2"),

    @JsonProperty("allApps")
    ALL_APPS("allApps", "4");

    private final String name;
    private final String value;

    private TargetedManagedAppGroupType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
