package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SynchronizationTaskExecutionResult implements Enum {

    @JsonProperty("Succeeded")
    SUCCEEDED("Succeeded", "0"),

    @JsonProperty("Failed")
    FAILED("Failed", "1"),

    @JsonProperty("EntryLevelErrors")
    ENTRY_LEVEL_ERRORS("EntryLevelErrors", "2");

    private final String name;
    private final String value;

    private SynchronizationTaskExecutionResult(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
