package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum StagedFeatureName implements Enum {

    @JsonProperty("passthroughAuthentication")
    PASSTHROUGH_AUTHENTICATION("passthroughAuthentication", "0"),

    @JsonProperty("seamlessSso")
    SEAMLESS_SSO("seamlessSso", "1"),

    @JsonProperty("passwordHashSync")
    PASSWORD_HASH_SYNC("passwordHashSync", "2"),

    @JsonProperty("emailAsAlternateId")
    EMAIL_AS_ALTERNATE_ID("emailAsAlternateId", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4"),

    @JsonProperty("certificateBasedAuthentication")
    CERTIFICATE_BASED_AUTHENTICATION("certificateBasedAuthentication", "5");

    private final String name;
    private final String value;

    private StagedFeatureName(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
