package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SingleSignOnMode implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("onPremisesKerberos")
    ON_PREMISES_KERBEROS("onPremisesKerberos", "1"),

    @JsonProperty("saml")
    SAML("saml", "3"),

    @JsonProperty("pingHeaderBased")
    PING_HEADER_BASED("pingHeaderBased", "4"),

    @JsonProperty("aadHeaderBased")
    AAD_HEADER_BASED("aadHeaderBased", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private SingleSignOnMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
