package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SimulationStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("draft")
    DRAFT("draft", "1"),

    @JsonProperty("running")
    RUNNING("running", "2"),

    @JsonProperty("scheduled")
    SCHEDULED("scheduled", "3"),

    @JsonProperty("succeeded")
    SUCCEEDED("succeeded", "4"),

    @JsonProperty("failed")
    FAILED("failed", "5"),

    @JsonProperty("cancelled")
    CANCELLED("cancelled", "6"),

    @JsonProperty("excluded")
    EXCLUDED("excluded", "7"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private SimulationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
