package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SignInAccessType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("b2bCollaboration")
    B2B_COLLABORATION("b2bCollaboration", "1"),

    @JsonProperty("b2bDirectConnect")
    B2B_DIRECT_CONNECT("b2bDirectConnect", "2"),

    @JsonProperty("microsoftSupport")
    MICROSOFT_SUPPORT("microsoftSupport", "4"),

    @JsonProperty("serviceProvider")
    SERVICE_PROVIDER("serviceProvider", "8"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "16");

    private final String name;
    private final String value;

    private SignInAccessType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
