package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ServiceUpdateCategory implements Enum {

    @JsonProperty("preventOrFixIssue")
    PREVENT_OR_FIX_ISSUE("preventOrFixIssue", "1"),

    @JsonProperty("planForChange")
    PLAN_FOR_CHANGE("planForChange", "2"),

    @JsonProperty("stayInformed")
    STAY_INFORMED("stayInformed", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private ServiceUpdateCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
